/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalListener;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalNotification;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrobatchSource<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
@UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
extends Source<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MicrobatchSource.class);
    private static volatile /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized MicrobatchSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> readerCache;
    private final @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source;
    private final @UnknownKeyFor @NonNull @Initialized Duration maxReadTime;
    private final @UnknownKeyFor @NonNull @Initialized int numInitialSplits;
    private final @UnknownKeyFor @NonNull @Initialized long maxNumRecords;
    private final @UnknownKeyFor @NonNull @Initialized int sourceId;
    private final @UnknownKeyFor @NonNull @Initialized double readerCacheInterval;
    private final @UnknownKeyFor @NonNull @Initialized int splitId;

    MicrobatchSource(@UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source, @UnknownKeyFor @NonNull @Initialized Duration maxReadTime, @UnknownKeyFor @NonNull @Initialized int numInitialSplits, @UnknownKeyFor @NonNull @Initialized long maxNumRecords, @UnknownKeyFor @NonNull @Initialized int splitId, @UnknownKeyFor @NonNull @Initialized int sourceId, @UnknownKeyFor @NonNull @Initialized double readerCacheInterval) {
        this.source = source;
        this.maxReadTime = maxReadTime;
        this.numInitialSplits = numInitialSplits;
        this.maxNumRecords = maxNumRecords;
        this.splitId = splitId;
        this.sourceId = sourceId;
        this.readerCacheInterval = readerCacheInterval;
    }

    private static synchronized void initReaderCache(@UnknownKeyFor @NonNull @Initialized long readerCacheInterval) {
        if (readerCache == null) {
            LOG.info("Creating reader cache. Cache interval = {} ms.", (Object)readerCacheInterval);
            readerCache = CacheBuilder.newBuilder().expireAfterAccess(readerCacheInterval, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new ReaderCacheRemovalListener()).build();
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] splitNumRecords(@UnknownKeyFor @NonNull @Initialized long numRecords, @UnknownKeyFor @NonNull @Initialized int numSplits) {
        int i;
        long[] splitNumRecords = new long[numSplits];
        for (i = 0; i < numSplits; ++i) {
            splitNumRecords[i] = numRecords / (long)numSplits;
        }
        i = 0;
        while ((long)i < numRecords % (long)numSplits) {
            splitNumRecords[i] = splitNumRecords[i] + 1L;
            ++i;
        }
        return splitNumRecords;
    }

    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Source<T>> split(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<MicrobatchSource<T, CheckpointMarkT>> result = new ArrayList<MicrobatchSource<T, CheckpointMarkT>>();
        List splits = this.source.split(this.numInitialSplits, options);
        int numSplits = splits.size();
        long[] numRecords = MicrobatchSource.splitNumRecords(this.maxNumRecords, numSplits);
        for (int i = 0; i < numSplits; ++i) {
            result.add(new MicrobatchSource<T, CheckpointMarkT>((UnboundedSource)splits.get(i), this.maxReadTime, 1, numRecords[i], i, this.sourceId, this.readerCacheInterval));
        }
        return result;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<T> getOrCreateReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, CheckpointMarkT checkpointMark) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            MicrobatchSource.initReaderCache((long)this.readerCacheInterval);
            return (Source.Reader)readerCache.get((Object)this, (Callable)new ReaderLoader(this, options, checkpointMark));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get or create reader", e);
        }
    }

    public void validate() {
        this.source.validate();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.source.getOutputCoder();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<CheckpointMarkT> getCheckpointMarkCoder() {
        return this.source.getCheckpointMarkCoder();
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.sourceId + "_" + this.splitId;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MicrobatchSource)) {
            return false;
        }
        MicrobatchSource that = (MicrobatchSource)((Object)o);
        if (this.sourceId != that.sourceId) {
            return false;
        }
        return this.splitId == that.splitId;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = this.sourceId;
        result = 31 * result + this.splitId;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearCache() {
        Class<MicrobatchSource> clazz = MicrobatchSource.class;
        synchronized (MicrobatchSource.class) {
            readerCache.invalidateAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class ReaderCacheRemovalListener
    implements RemovalListener<MicrobatchSource<?, ?>, Source.Reader<?>> {
        private ReaderCacheRemovalListener() {
        }

        public void onRemoval(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RemovalNotification<@UnknownKeyFor @NonNull @Initialized MicrobatchSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Source.Reader<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> notification) {
            try {
                ((Source.Reader)notification.getValue()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReaderLoader
    implements Callable<Source.Reader<T>> {
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
        private final CheckpointMarkT checkpointMark;
        final /* synthetic */ MicrobatchSource this$0;

        ReaderLoader(PipelineOptions options, CheckpointMarkT checkpointMark) {
            this.this$0 = var1_1;
            this.options = options;
            this.checkpointMark = checkpointMark;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MicrobatchSource. @UnknownKeyFor @NonNull @Initialized Reader call() throws @UnknownKeyFor @NonNull @Initialized Exception {
            LOG.info("No cached reader found for split: [{}]. Creating new reader at checkpoint mark {}", (Object)this.this$0.source, this.checkpointMark);
            return this.this$0.new Reader(this.this$0.source.createReader(this.options, this.checkpointMark));
        }
    }

    public class Reader
    extends Source.Reader<T> {
        private @UnknownKeyFor @NonNull @Initialized long recordsRead = 0L;
        private @UnknownKeyFor @NonNull @Initialized Instant readEndTime;
        private final @UnknownKeyFor @NonNull @Initialized FluentBackoff backoffFactory;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<T> unboundedReader;
        private @UnknownKeyFor @NonNull @Initialized boolean started;

        private Reader(UnboundedSource.UnboundedReader<T> unboundedReader) {
            this.unboundedReader = unboundedReader;
            this.backoffFactory = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)10L)).withMaxBackoff(MicrobatchSource.this.maxReadTime.minus((ReadableDuration)Duration.millis((long)1L))).withMaxCumulativeBackoff(MicrobatchSource.this.maxReadTime.minus((ReadableDuration)Duration.millis((long)1L)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private @UnknownKeyFor @NonNull @Initialized boolean startIfNeeded() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.started) return false;
            this.started = true;
            if (!true) return false;
            if (!this.unboundedReader.start()) return false;
            return true;
        }

        private void prepareForNewBatchReading() {
            this.readEndTime = Instant.now().plus((ReadableDuration)MicrobatchSource.this.maxReadTime);
            this.recordsRead = 0L;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            LOG.debug("MicrobatchReader-{}: Starting a microbatch read from an unbounded source with a max read time of {} millis, and max number of records {}.", new Object[]{MicrobatchSource.this.splitId, MicrobatchSource.this.maxReadTime, MicrobatchSource.this.maxNumRecords});
            this.prepareForNewBatchReading();
            return this.startIfNeeded() || this.advanceWithBackoff();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.recordsRead >= MicrobatchSource.this.maxNumRecords) {
                this.finalizeCheckpoint();
                return false;
            }
            return this.advanceWithBackoff();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean advanceWithBackoff() throws @UnknownKeyFor @NonNull @Initialized IOException {
            BackOff backoff = this.backoffFactory.backoff();
            long nextSleep = backoff.nextBackOffMillis();
            while (nextSleep != -1L) {
                if (this.readEndTime != null && Instant.now().isAfter((ReadableInstant)this.readEndTime)) {
                    this.finalizeCheckpoint();
                    return false;
                }
                if (this.unboundedReader.advance()) {
                    ++this.recordsRead;
                    return true;
                }
                Uninterruptibles.sleepUninterruptibly((long)nextSleep, (TimeUnit)TimeUnit.MILLISECONDS);
                nextSleep = backoff.nextBackOffMillis();
            }
            this.finalizeCheckpoint();
            return false;
        }

        private void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.unboundedReader.getCheckpointMark().finalizeCheckpoint();
            LOG.debug("MicrobatchReader-{}: finalized CheckpointMark successfully after reading {} records.", (Object)MicrobatchSource.this.splitId, (Object)this.recordsRead);
        }

        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.unboundedReader.getCurrent();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.unboundedReader.getCurrentTimestamp();
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.unboundedReader.close();
        }

        public @UnknownKeyFor @NonNull @Initialized Source<T> getCurrentSource() {
            return MicrobatchSource.this;
        }

        public CheckpointMarkT getCheckpointMark() {
            return this.unboundedReader.getCheckpointMark();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return this.unboundedReader.getWatermark();
        }
    }
}

