/*
 * Decompiled with CFR 0.152.
 */
package jflex.logging;

import java.awt.TextArea;
import java.io.OutputStream;
import java.io.PrintWriter;
import jflex.logging.Out;

public final class StdOutWriter
extends PrintWriter {
    private TextArea text;
    private int col;
    private static final int wrap = 78;

    public StdOutWriter() {
        super(System.out, true);
    }

    public StdOutWriter(OutputStream out) {
        super(out, true);
    }

    public void setGUIMode(TextArea text) {
        this.text = text;
    }

    @Override
    public void write(int c) {
        if (this.text != null) {
            this.text.append(String.valueOf((char)c));
            if (++this.col > 78) {
                this.println();
            }
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.text != null) {
            this.text.append(new String(buf, off, len));
            if ((this.col += len) > 78) {
                this.println();
            }
        } else {
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        if (this.text != null) {
            this.text.append(s.substring(off, off + len));
            if ((this.col += len) > 78) {
                this.println();
            }
        } else {
            super.write(s, off, len);
            this.flush();
        }
    }

    @Override
    public void println() {
        if (this.text != null) {
            this.text.append(Out.NL);
            this.col = 0;
        } else {
            super.println();
        }
    }
}

