/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.util;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeComparatorFactory;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.PlanNode;

public final class Utils {
    public static FieldList createOrderedFromSet(FieldSet set) {
        if (set instanceof FieldList) {
            return (FieldList)set;
        }
        int[] cols = set.toArray();
        Arrays.sort(cols);
        return new FieldList(cols);
    }

    public static Ordering createOrdering(FieldList fields, boolean[] directions) {
        Ordering o = new Ordering();
        for (int i = 0; i < fields.size(); ++i) {
            o.appendOrdering(fields.get(i), null, directions == null || directions[i] ? Order.ASCENDING : Order.DESCENDING);
        }
        return o;
    }

    public static Ordering createOrdering(FieldList fields) {
        Ordering o = new Ordering();
        for (int i = 0; i < fields.size(); ++i) {
            o.appendOrdering(fields.get(i), null, Order.ANY);
        }
        return o;
    }

    public static boolean[] getDirections(Ordering o, int numFields) {
        boolean[] dirs = o.getFieldSortDirections();
        if (dirs.length == numFields) {
            return dirs;
        }
        if (dirs.length > numFields) {
            boolean[] subSet = new boolean[numFields];
            System.arraycopy(dirs, 0, subSet, 0, numFields);
            return subSet;
        }
        throw new CompilerException();
    }

    public static TypeComparatorFactory<?> getShipComparator(Channel channel, ExecutionConfig executionConfig) {
        PlanNode source = channel.getSource();
        Operator<?> javaOp = source.getProgramOperator();
        TypeInformation type = javaOp.getOperatorInfo().getOutputType();
        return Utils.createComparator(type, channel.getShipStrategyKeys(), Utils.getSortOrders(channel.getShipStrategyKeys(), channel.getShipStrategySortOrder()), executionConfig);
    }

    private static <T> TypeComparatorFactory<?> createComparator(TypeInformation<T> typeInfo, FieldList keys, boolean[] sortOrder, ExecutionConfig executionConfig) {
        TypeComparator comparator;
        if (typeInfo instanceof CompositeType) {
            comparator = ((CompositeType)typeInfo).createComparator(keys.toArray(), sortOrder, 0, executionConfig);
        } else if (typeInfo instanceof AtomicType) {
            comparator = ((AtomicType)typeInfo).createComparator(sortOrder[0], executionConfig);
        } else {
            throw new RuntimeException("Unrecognized type: " + typeInfo);
        }
        return new RuntimeComparatorFactory(comparator);
    }

    private static boolean[] getSortOrders(FieldList keys, boolean[] orders) {
        if (orders == null) {
            orders = new boolean[keys.size()];
            Arrays.fill(orders, true);
        }
        return orders;
    }

    private Utils() {
        throw new RuntimeException();
    }
}

