/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.CallTemplate;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCallTemplate
extends StyleElement {
    private int calledTemplateFingerprint = -1;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private String calledTemplateName = null;
    private Expression calledTemplateExpression;

    protected boolean allowAVT() {
        return false;
    }

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.template == null) {
            return AnyItemType.getInstance();
        }
        return this.template.getReturnedItemType();
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        if (this.allowAVT() && string.indexOf(123) >= 0) {
            this.calledTemplateExpression = this.makeAttributeValueTemplate(string);
        } else {
            this.calledTemplateName = string;
            try {
                this.calledTemplateFingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage(), "XTSE0280");
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XTSE0280");
            }
        }
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLWithParam || nodeInfo instanceof XSLFallback && this.mayContainFallback()) continue;
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:call-template", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(nodeInfo.getDisplayName(), 1) + " is not allowed within xsl:call-template", "XTSE0010");
        }
        if (this.calledTemplateExpression == null) {
            this.template = this.findTemplate(this.calledTemplateFingerprint);
            if (this.template == null) {
                return;
            }
        }
        this.calledTemplateExpression = this.typeCheck("name", this.calledTemplateExpression);
    }

    public void postValidate() throws XPathException {
        if (this.template != null) {
            Object object;
            Object object2;
            Object object3;
            AxisIterator axisIterator = this.template.iterateAxis((byte)3);
            while ((object3 = (NodeInfo)axisIterator.next()) != null) {
                if (!(object3 instanceof XSLParam) || !((XSLParam)object3).isRequiredParam() || ((XSLParam)object3).isTunnelParam()) continue;
                object2 = this.iterateAxis((byte)3);
                boolean bl = false;
                while ((object = (NodeInfo)object2.next()) != null) {
                    if (!(object instanceof XSLWithParam) || ((XSLWithParam)object).getVariableFingerprint() != ((XSLParam)object3).getVariableFingerprint()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.compileError("No value supplied for required parameter " + Err.wrap(((XSLParam)object3).getVariableName(), 5), "XTSE0690");
            }
            object3 = this.iterateAxis((byte)3);
            while ((object2 = (NodeInfo)object3.next()) != null) {
                NodeInfo nodeInfo;
                if (!(object2 instanceof XSLWithParam) || ((XSLWithParam)object2).isTunnelParam()) continue;
                XSLWithParam xSLWithParam = (XSLWithParam)object2;
                object = this.template.iterateAxis((byte)3);
                boolean bl = false;
                while ((nodeInfo = (NodeInfo)object.next()) != null) {
                    if (!(nodeInfo instanceof XSLParam) || ((XSLParam)nodeInfo).getVariableFingerprint() != xSLWithParam.getVariableFingerprint()) continue;
                    bl = true;
                    SequenceType sequenceType = ((XSLParam)nodeInfo).getRequiredType();
                    xSLWithParam.checkAgainstRequiredType(sequenceType);
                    break;
                }
                if (bl || this.backwardsCompatibleModeIsEnabled()) continue;
                this.compileError("Parameter " + xSLWithParam.getVariableName() + " is not declared in the called template", "XTSE0680");
            }
        }
    }

    private XSLTemplate findTemplate(int n) throws XPathException {
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        for (int i = list.size() - 1; i >= 0; --i) {
            XSLTemplate xSLTemplate;
            if (!(list.get(i) instanceof XSLTemplate) || (xSLTemplate = (XSLTemplate)list.get(i)).getTemplateFingerprint() != n) continue;
            return xSLTemplate;
        }
        this.compileError("No template exists named " + this.calledTemplateName, "XTSE0650");
        return null;
    }

    public void markTailCalls() {
        this.useTailRecursion = true;
    }

    public Expression compile(Executable executable) throws XPathException {
        Template template = null;
        SavedNamespaceContext savedNamespaceContext = null;
        if (this.calledTemplateExpression == null) {
            if (this.template == null) {
                return null;
            }
            template = this.template.getCompiledTemplate();
        } else {
            savedNamespaceContext = this.makeNamespaceContext();
        }
        CallTemplate callTemplate = new CallTemplate(template, this.useTailRecursion, this.calledTemplateExpression, savedNamespaceContext);
        callTemplate.setActualParameters(this.getWithParamInstructions(executable, false, callTemplate), this.getWithParamInstructions(executable, true, callTemplate));
        ExpressionTool.makeParentReferences(callTemplate);
        return callTemplate;
    }
}

