/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.blockuntiltransformsfinish;

import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.blockuntiltransformsfinish.BlockUntilTransformsFinishData;
import org.apache.hop.pipeline.transforms.blockuntiltransformsfinish.BlockUntilTransformsFinishMeta;
import org.apache.hop.pipeline.transforms.blockuntiltransformsfinish.BlockingTransform;

public class BlockUntilTransformsFinish
extends BaseTransform<BlockUntilTransformsFinishMeta, BlockUntilTransformsFinishData> {
    private static final Class<?> PKG = BlockUntilTransformsFinishMeta.class;

    public BlockUntilTransformsFinish(TransformMeta transformMeta, BlockUntilTransformsFinishMeta meta, BlockUntilTransformsFinishData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            if (((BlockUntilTransformsFinishMeta)this.meta).getBlockingTransforms().isEmpty()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinish.Error.NotTransforms", (String[])new String[0]));
            }
            String[] targetTransforms = this.getPipelineMeta().getNextTransformNames(this.getTransformMeta());
            ((BlockUntilTransformsFinishData)this.data).componentMap.clear();
            for (int i = 0; i < ((BlockUntilTransformsFinishMeta)this.meta).getBlockingTransforms().size(); ++i) {
                BlockingTransform blockingTransform = ((BlockUntilTransformsFinishMeta)this.meta).getBlockingTransforms().get(i);
                if (blockingTransform.getName().equals(this.getTransformName())) {
                    throw new HopException("You can not wait for transform [" + blockingTransform.getName() + "] to finish!");
                }
                if (targetTransforms != null) {
                    for (int j = 0; j < targetTransforms.length; ++j) {
                        if (!blockingTransform.getName().equals(targetTransforms[j])) continue;
                        throw new HopException("You can not get metrics for the target transform [" + targetTransforms[j] + "]!");
                    }
                }
                int copyNr = Const.toInt((String)blockingTransform.getCopyNr(), (int)0);
                IEngineComponent component = this.getDispatcher().findComponent(blockingTransform.getName(), copyNr);
                if (component == null) {
                    throw new HopException("Error finding transform [" + blockingTransform.getName() + "] nr copy=" + copyNr + "!");
                }
                ((BlockUntilTransformsFinishData)this.data).componentMap.put(i, component);
            }
        }
        while (((BlockUntilTransformsFinishData)this.data).continueLoop && !this.isStopped()) {
            ((BlockUntilTransformsFinishData)this.data).continueLoop = false;
            for (Map.Entry<Integer, IEngineComponent> e : ((BlockUntilTransformsFinishData)this.data).componentMap.entrySet()) {
                IEngineComponent transform = e.getValue();
                if (transform.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_RUNNING || transform.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_IDLE || transform.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_INIT || transform.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_PAUSED) {
                    ((BlockUntilTransformsFinishData)this.data).continueLoop = true;
                    continue;
                }
                this.log.logBasic("Transform " + transform.getName() + " status: " + transform.getStatusDescription());
                ((BlockUntilTransformsFinishData)this.data).componentMap.remove(e.getKey());
                if (!this.log.isDetailed()) continue;
                this.logDetailed("Finished running transform [" + transform.getName() + "(" + transform.getCopyNr() + ")].");
            }
            if (!((BlockUntilTransformsFinishData)this.data).continueLoop) continue;
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), r);
        return true;
    }
}

