/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.om.ValueRepresentation;

public class ParameterSet {
    private int[] keys;
    private ValueRepresentation[] values;
    private int used = 0;
    public static ParameterSet EMPTY_PARAMETER_SET = new ParameterSet(0);

    public ParameterSet() {
        this(10);
    }

    public ParameterSet(int n) {
        this.keys = new int[n];
        this.values = new ValueRepresentation[n];
    }

    public ParameterSet(ParameterSet parameterSet, int n) {
        this(parameterSet.used + n);
        for (int i = 0; i < parameterSet.used; ++i) {
            this.put(parameterSet.keys[i], parameterSet.values[i]);
        }
    }

    public void put(int n, ValueRepresentation valueRepresentation) {
        int n2;
        for (n2 = 0; n2 < this.used; ++n2) {
            if (this.keys[n2] != n) continue;
            this.values[n2] = valueRepresentation;
            return;
        }
        if (this.used + 1 > this.keys.length) {
            n2 = this.used <= 5 ? 10 : this.used * 2;
            int[] nArray = new int[n2];
            ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[n2];
            System.arraycopy(this.values, 0, valueRepresentationArray, 0, this.used);
            System.arraycopy(this.keys, 0, nArray, 0, this.used);
            this.values = valueRepresentationArray;
            this.keys = nArray;
        }
        this.keys[this.used] = n;
        this.values[this.used++] = valueRepresentation;
    }

    public ValueRepresentation get(int n) {
        for (int i = 0; i < this.used; ++i) {
            if (this.keys[i] != n) continue;
            return this.values[i];
        }
        return null;
    }

    public void clear() {
        this.used = 0;
    }
}

