/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmloutput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlField;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlOutputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class XmlOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = XmlOutputMeta.class;
    private TextVar wFilename;
    private TextVar wExtension;
    private Button wAddTransformnr;
    private Label wlAddDate;
    private Button wAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private Button wZipped;
    private Button wOmitNullValues;
    private CCombo wEncoding;
    private Text wNameSpace;
    private CCombo wMainElement;
    private CCombo wRepeatElement;
    private Text wSplitEvery;
    private TableView wFields;
    private final XmlOutputMeta input;
    private boolean gotEncodings = false;
    private Button wAddToResult;
    private Button wDoNotOpenNewFileInit;
    private Button wSpecifyFormat;
    private Label wlDateTimeFormat;
    private CCombo wDateTimeFormat;
    private ColumnInfo[] colinf;
    private final Map<String, Integer> inputFields;

    public XmlOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (XmlOutputMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.FileTab.Tab", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Label wlFilename = new Label(wFileComp, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment(0, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Browse.Button", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment(0, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment(0, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlDoNotOpenNewFileInit = new Label(wFileComp, 131072);
        wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDoNotOpenNewFileInit);
        FormData fdlDoNotOpenNewFileInit = new FormData();
        fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wFilename, margin);
        fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        wlDoNotOpenNewFileInit.setLayoutData((Object)fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button(wFileComp, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDoNotOpenNewFileInit);
        FormData fdDoNotOpenNewFileInit = new FormData();
        fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        fdDoNotOpenNewFileInit.top = new FormAttachment((Control)wlDoNotOpenNewFileInit, 0, 0x1000000);
        fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
            }
        });
        Label wlExtension = new Label(wFileComp, 131072);
        wlExtension.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Extension.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExtension);
        FormData fdlExtension = new FormData();
        fdlExtension.left = new FormAttachment(0, 0);
        fdlExtension.top = new FormAttachment((Control)wlDoNotOpenNewFileInit, 2 * margin);
        fdlExtension.right = new FormAttachment(middle, -margin);
        wlExtension.setLayoutData((Object)fdlExtension);
        this.wExtension = new TextVar(this.variables, wFileComp, 18436);
        this.wExtension.setText("");
        PropsUi.setLook((Widget)this.wExtension);
        this.wExtension.addModifyListener(lsMod);
        FormData fdExtension = new FormData();
        fdExtension.left = new FormAttachment(middle, 0);
        fdExtension.top = new FormAttachment((Control)wlDoNotOpenNewFileInit, 2 * margin);
        fdExtension.right = new FormAttachment(100, 0);
        this.wExtension.setLayoutData((Object)fdExtension);
        Label wlAddTransformnr = new Label(wFileComp, 131072);
        wlAddTransformnr.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddTransformNr.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddTransformnr);
        FormData fdlAddTransformnr = new FormData();
        fdlAddTransformnr.left = new FormAttachment(0, 0);
        fdlAddTransformnr.top = new FormAttachment((Control)this.wExtension, margin);
        fdlAddTransformnr.right = new FormAttachment(middle, -margin);
        wlAddTransformnr.setLayoutData((Object)fdlAddTransformnr);
        this.wAddTransformnr = new Button(wFileComp, 32);
        PropsUi.setLook((Widget)this.wAddTransformnr);
        FormData fdAddTransformnr = new FormData();
        fdAddTransformnr.left = new FormAttachment(middle, 0);
        fdAddTransformnr.top = new FormAttachment((Control)wlAddTransformnr, 0, 0x1000000);
        fdAddTransformnr.right = new FormAttachment(100, 0);
        this.wAddTransformnr.setLayoutData((Object)fdAddTransformnr);
        this.wAddTransformnr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddDate = new Label(wFileComp, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)this.wAddTransformnr, margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button(wFileComp, 32);
        PropsUi.setLook((Widget)this.wAddDate);
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)this.wlAddDate, 0, 0x1000000);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddTime = new Label(wFileComp, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button(wFileComp, 32);
        PropsUi.setLook((Widget)this.wAddTime);
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)this.wlAddTime, 0, 0x1000000);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
            }
        });
        Label wlSpecifyFormat = new Label(wFileComp, 131072);
        wlSpecifyFormat.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.SpecifyFormat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpecifyFormat);
        FormData fdlSpecifyFormat = new FormData();
        fdlSpecifyFormat.left = new FormAttachment(0, 0);
        fdlSpecifyFormat.top = new FormAttachment((Control)this.wAddTime, margin);
        fdlSpecifyFormat.right = new FormAttachment(middle, -margin);
        wlSpecifyFormat.setLayoutData((Object)fdlSpecifyFormat);
        this.wSpecifyFormat = new Button(wFileComp, 32);
        PropsUi.setLook((Widget)this.wSpecifyFormat);
        this.wSpecifyFormat.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.SpecifyFormat.Tooltip", (String[])new String[0]));
        FormData fdSpecifyFormat = new FormData();
        fdSpecifyFormat.left = new FormAttachment(middle, 0);
        fdSpecifyFormat.top = new FormAttachment((Control)wlSpecifyFormat, 0, 0x1000000);
        fdSpecifyFormat.right = new FormAttachment(100, 0);
        this.wSpecifyFormat.setLayoutData((Object)fdSpecifyFormat);
        this.wSpecifyFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
                XmlOutputDialog.this.setDateTimeFormat();
            }
        });
        String[] dats = Const.getDateFormats();
        this.wlDateTimeFormat = new Label(wFileComp, 131072);
        this.wlDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DateTimeFormat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDateTimeFormat);
        FormData fdlDateTimeFormat = new FormData();
        fdlDateTimeFormat.left = new FormAttachment(0, 0);
        fdlDateTimeFormat.top = new FormAttachment((Control)this.wSpecifyFormat, margin);
        fdlDateTimeFormat.right = new FormAttachment(middle, -margin);
        this.wlDateTimeFormat.setLayoutData((Object)fdlDateTimeFormat);
        this.wDateTimeFormat = new CCombo(wFileComp, 2056);
        this.wDateTimeFormat.setEditable(true);
        PropsUi.setLook((Widget)this.wDateTimeFormat);
        this.wDateTimeFormat.addModifyListener(lsMod);
        FormData fdDateTimeFormat = new FormData();
        fdDateTimeFormat.left = new FormAttachment(middle, 0);
        fdDateTimeFormat.top = new FormAttachment((Control)this.wSpecifyFormat, margin);
        fdDateTimeFormat.right = new FormAttachment(100, 0);
        this.wDateTimeFormat.setLayoutData((Object)fdDateTimeFormat);
        for (String dat : dats) {
            this.wDateTimeFormat.add(dat);
        }
        Button wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)wbShowFiles);
        wbShowFiles.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.top = new FormAttachment((Control)this.wDateTimeFormat, margin * 2);
        wbShowFiles.setLayoutData((Object)fdbShowFiles);
        wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputMeta tfoi = new XmlOutputMeta();
                XmlOutputDialog.this.getInfo(tfoi);
                String[] files = tfoi.getFiles(XmlOutputDialog.this.variables);
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(XmlOutputDialog.this.shell, files, BaseMessages.getString(PKG, (String)"XMLOutputDialog.OutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLOutputDialog.OutputFiles.DialogMessage", (String[])new String[0]));
                    esd.setViewOnly();
                    esd.open();
                } else {
                    MessageBox mb = new MessageBox(XmlOutputDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"XMLOutputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        Label wlAddToResult = new Label(wFileComp, 131072);
        wlAddToResult.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddToResult);
        FormData fdlAddToResult = new FormData();
        fdlAddToResult.left = new FormAttachment(0, 0);
        fdlAddToResult.top = new FormAttachment((Control)wbShowFiles, 2 * margin);
        fdlAddToResult.right = new FormAttachment(middle, -margin);
        wlAddToResult.setLayoutData((Object)fdlAddToResult);
        this.wAddToResult = new Button(wFileComp, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAddToResult);
        FormData fdAddToResult = new FormData();
        fdAddToResult.left = new FormAttachment(middle, 0);
        fdAddToResult.top = new FormAttachment((Control)wlAddToResult, 0, 0x1000000);
        fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XmlOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Label wlZipped = new Label(wContentComp, 131072);
        wlZipped.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Zipped.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlZipped);
        FormData fdlZipped = new FormData();
        fdlZipped.left = new FormAttachment(0, 0);
        fdlZipped.top = new FormAttachment(0, 0);
        fdlZipped.right = new FormAttachment(middle, -margin);
        wlZipped.setLayoutData((Object)fdlZipped);
        this.wZipped = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wZipped);
        FormData fdZipped = new FormData();
        fdZipped.left = new FormAttachment(middle, 0);
        fdZipped.top = new FormAttachment((Control)wlZipped, 0, 0x1000000);
        fdZipped.right = new FormAttachment(100, 0);
        this.wZipped.setLayoutData((Object)fdZipped);
        this.wZipped.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
            }
        });
        Label wlEncoding = new Label(wContentComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wZipped, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wZipped, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)XmlOutputDialog.this.shell.getDisplay(), 1);
                XmlOutputDialog.this.shell.setCursor(busy);
                XmlOutputDialog.this.setEncodings();
                XmlOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlNameSpace = new Label(wContentComp, 131072);
        wlNameSpace.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.NameSpace.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNameSpace);
        FormData fdlNameSpace = new FormData();
        fdlNameSpace.left = new FormAttachment(0, 0);
        fdlNameSpace.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlNameSpace.right = new FormAttachment(middle, -margin);
        wlNameSpace.setLayoutData((Object)fdlNameSpace);
        this.wNameSpace = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wNameSpace);
        this.wNameSpace.addModifyListener(lsMod);
        FormData fdNameSpace = new FormData();
        fdNameSpace.left = new FormAttachment(middle, 0);
        fdNameSpace.top = new FormAttachment((Control)this.wEncoding, margin);
        fdNameSpace.right = new FormAttachment(100, 0);
        this.wNameSpace.setLayoutData((Object)fdNameSpace);
        Label wlMainElement = new Label(wContentComp, 131072);
        wlMainElement.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.MainElement.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMainElement);
        FormData fdlMainElement = new FormData();
        fdlMainElement.left = new FormAttachment(0, 0);
        fdlMainElement.top = new FormAttachment((Control)this.wNameSpace, margin);
        fdlMainElement.right = new FormAttachment(middle, -margin);
        wlMainElement.setLayoutData((Object)fdlMainElement);
        this.wMainElement = new CCombo(wContentComp, 2056);
        this.wMainElement.setEditable(true);
        PropsUi.setLook((Widget)this.wMainElement);
        this.wMainElement.addModifyListener(lsMod);
        FormData fdMainElement = new FormData();
        fdMainElement.left = new FormAttachment(middle, 0);
        fdMainElement.top = new FormAttachment((Control)this.wNameSpace, margin);
        fdMainElement.right = new FormAttachment(100, 0);
        this.wMainElement.setLayoutData((Object)fdMainElement);
        Label wlRepeatElement = new Label(wContentComp, 131072);
        wlRepeatElement.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.RepeatElement.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRepeatElement);
        FormData fdlRepeatElement = new FormData();
        fdlRepeatElement.left = new FormAttachment(0, 0);
        fdlRepeatElement.top = new FormAttachment((Control)this.wMainElement, margin);
        fdlRepeatElement.right = new FormAttachment(middle, -margin);
        wlRepeatElement.setLayoutData((Object)fdlRepeatElement);
        this.wRepeatElement = new CCombo(wContentComp, 2056);
        this.wRepeatElement.setEditable(true);
        PropsUi.setLook((Widget)this.wRepeatElement);
        this.wRepeatElement.addModifyListener(lsMod);
        FormData fdRepeatElement = new FormData();
        fdRepeatElement.left = new FormAttachment(middle, 0);
        fdRepeatElement.top = new FormAttachment((Control)this.wMainElement, margin);
        fdRepeatElement.right = new FormAttachment(100, 0);
        this.wRepeatElement.setLayoutData((Object)fdRepeatElement);
        Label wlSplitEvery = new Label(wContentComp, 131072);
        wlSplitEvery.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.SplitEvery.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSplitEvery);
        FormData fdlSplitEvery = new FormData();
        fdlSplitEvery.left = new FormAttachment(0, 0);
        fdlSplitEvery.top = new FormAttachment((Control)this.wRepeatElement, margin);
        fdlSplitEvery.right = new FormAttachment(middle, -margin);
        wlSplitEvery.setLayoutData((Object)fdlSplitEvery);
        this.wSplitEvery = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wSplitEvery);
        this.wSplitEvery.addModifyListener(lsMod);
        FormData fdSplitEvery = new FormData();
        fdSplitEvery.left = new FormAttachment(middle, 0);
        fdSplitEvery.top = new FormAttachment((Control)this.wRepeatElement, margin);
        fdSplitEvery.right = new FormAttachment(100, 0);
        this.wSplitEvery.setLayoutData((Object)fdSplitEvery);
        Label wlOmitNullValues = new Label(wContentComp, 131072);
        wlOmitNullValues.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.OmitNullValues.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOmitNullValues);
        FormData fdlOmitNullValues = new FormData();
        fdlOmitNullValues.left = new FormAttachment(0, 0);
        fdlOmitNullValues.top = new FormAttachment((Control)this.wSplitEvery, margin);
        fdlOmitNullValues.right = new FormAttachment(middle, -margin);
        wlOmitNullValues.setLayoutData((Object)fdlOmitNullValues);
        this.wOmitNullValues = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wOmitNullValues);
        FormData fdOmitNullValues = new FormData();
        fdOmitNullValues.left = new FormAttachment(middle, 0);
        fdOmitNullValues.top = new FormAttachment((Control)wlOmitNullValues, 0, 0x1000000);
        fdOmitNullValues.right = new FormAttachment(100, 0);
        this.wOmitNullValues.setLayoutData((Object)fdOmitNullValues);
        this.wOmitNullValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlOutputDialog.this.input.setChanged();
            }
        });
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        PropsUi.setLook((Widget)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Get.Button", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Get.Tooltip", (String[])new String[0]));
        Button wMinWidth = new Button(wFieldsComp, 8);
        wMinWidth.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.MinWidth.Label", (String[])new String[0]));
        wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.MinWidth.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet, wMinWidth}, margin, null);
        int FieldsRows = this.input.getOutputFields().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ElementName.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ContentType.Column", (String[])new String[0]), 2, new String[]{"Element", "Attribute"}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Type.Column", (String[])new String[0]), 2, ValueMetaBase.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Format.Column", (String[])new String[0]), 5, 5), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Null.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        wMinWidth.addListener(13, e -> this.setMinimalWidth());
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.xml", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.XMLFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.getData();
        this.setDateTimeFormat();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setDateTimeFormat() {
        if (this.wSpecifyFormat.getSelection()) {
            this.wAddDate.setSelection(false);
            this.wAddTime.setSelection(false);
        }
        this.wDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wlDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void getData() {
        if (this.input.getFileName() != null) {
            this.wFilename.setText(this.input.getFileName());
        }
        if (this.input.getExtension() != null) {
            this.wExtension.setText(this.input.getExtension());
        }
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getNameSpace() != null) {
            this.wNameSpace.setText(this.input.getNameSpace());
        }
        if (this.input.getMainElement() != null) {
            this.wMainElement.setText(this.input.getMainElement());
        }
        if (this.input.getRepeatElement() != null) {
            this.wRepeatElement.setText(this.input.getRepeatElement());
        }
        this.wSplitEvery.setText("" + this.input.getSplitEvery());
        this.wZipped.setSelection(this.input.isZipped());
        this.wOmitNullValues.setSelection(this.input.isOmitNullValues());
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wAddTransformnr.setSelection(this.input.isTransformNrInFilename());
        this.wAddToResult.setSelection(this.input.isAddToResultFiles());
        if (this.input.getDateTimeFormat() != null) {
            this.wDateTimeFormat.setText(this.input.getDateTimeFormat());
        }
        this.wSpecifyFormat.setSelection(this.input.isSpecifyFormat());
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            XmlField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            int index = 1;
            if (field.getFieldName() != null) {
                item.setText(index++, field.getFieldName());
            }
            if (field.getElementName() != null) {
                item.setText(index++, field.getElementName());
            } else if (field.getFieldName() != null) {
                item.setText(index++, field.getFieldName());
            }
            int n = ++index;
            item.setText(n, field.getContentType().name());
            int n2 = ++index;
            ++index;
            item.setText(n2, field.getTypeDesc());
            if (field.getFormat() != null) {
                item.setText(index++, field.getFormat());
            } else {
                ++index;
            }
            if (field.getLength() >= 0) {
                item.setText(index++, "" + field.getLength());
            } else {
                ++index;
            }
            if (field.getPrecision() >= 0) {
                item.setText(index++, "" + field.getPrecision());
            } else {
                ++index;
            }
            if (field.getCurrencySymbol() != null) {
                item.setText(index++, field.getCurrencySymbol());
            } else {
                ++index;
            }
            if (field.getDecimalSymbol() != null) {
                item.setText(index++, field.getDecimalSymbol());
            } else {
                ++index;
            }
            if (field.getGroupingSymbol() != null) {
                item.setText(index++, field.getGroupingSymbol());
            } else {
                ++index;
            }
            if (field.getNullString() != null) {
                item.setText(index++, field.getNullString());
                continue;
            }
            ++index;
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(XmlOutputMeta xmlOutputMeta) {
        xmlOutputMeta.setFileName(this.wFilename.getText());
        xmlOutputMeta.setEncoding(this.wEncoding.getText());
        xmlOutputMeta.setNameSpace(this.wNameSpace.getText());
        xmlOutputMeta.setMainElement(this.wMainElement.getText());
        xmlOutputMeta.setRepeatElement(this.wRepeatElement.getText());
        xmlOutputMeta.setExtension(this.wExtension.getText());
        xmlOutputMeta.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
        xmlOutputMeta.setSplitEvery(Const.toInt((String)this.wSplitEvery.getText(), (int)0));
        xmlOutputMeta.setDateTimeFormat(this.wDateTimeFormat.getText());
        xmlOutputMeta.setSpecifyFormat(this.wSpecifyFormat.getSelection());
        xmlOutputMeta.setTransformNrInFilename(this.wAddTransformnr.getSelection());
        xmlOutputMeta.setDateInFilename(this.wAddDate.getSelection());
        xmlOutputMeta.setTimeInFilename(this.wAddTime.getSelection());
        xmlOutputMeta.setAddToResultFiles(this.wAddToResult.getSelection());
        xmlOutputMeta.setZipped(this.wZipped.getSelection());
        xmlOutputMeta.setOmitNullValues(this.wOmitNullValues.getSelection());
        int nrFields = this.wFields.nrNonEmpty();
        xmlOutputMeta.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            XmlField field = new XmlField();
            TableItem item = this.wFields.getNonEmpty(i);
            int index = 1;
            field.setFieldName(item.getText(index++));
            field.setElementName(item.getText(index++));
            if (field.getFieldName().equals(field.getElementName())) {
                field.setElementName("");
            }
            field.setContentType(XmlField.ContentType.getIfPresent(item.getText(index++)));
            field.setType(item.getText(index++));
            field.setFormat(item.getText(index++));
            field.setLength(Const.toInt((String)item.getText(index++), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(index++), (int)-1));
            field.setCurrencySymbol(item.getText(index++));
            field.setDecimalSymbol(item.getText(index++));
            field.setGroupingSymbol(item.getText(index++));
            field.setNullString(item.getText(index++));
            xmlOutputMeta.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, XmlField.ContentType.Element.name());
                    if (v.isNumber() && v.getLength() > 0) {
                        int m;
                        int le = v.getLength();
                        int pr = v.getPrecision();
                        if (v.getPrecision() <= 0) {
                            pr = 0;
                        }
                        Object mask = " ";
                        for (m = 0; m < le - pr; ++m) {
                            mask = (String)mask + "0";
                        }
                        if (pr > 0) {
                            mask = (String)mask + ".";
                        }
                        for (m = 0; m < pr; ++m) {
                            mask = (String)mask + "0";
                        }
                        tableItem.setText(4, (String)mask);
                    }
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{4}, (int)6, (int)7, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(5, "");
            item.setText(6, "");
            int type = ValueMetaBase.getType((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(4, "");
                    continue block6;
                }
                case 5: {
                    item.setText(4, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(4, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        this.wFields.optWidth(true);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }
}

