/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.userdefinedjavaclass;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.DataTypeConverter;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.injection.NullNumberConverter;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.InfoTransformDefinition;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.TargetTransformDefinition;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.TransformClassBase;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UsageParameter;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClass;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassData;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassDef;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.Scanner;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="UserDefinedJavaClass.Injection.", groups={"PARAMETERS", "TARGET_TRANSFORMS", "INFO_TRANSFORMS", "JAVA_CLASSES", "FIELD_INFO"})
@Transform(id="UserDefinedJavaClass", image="userdefinedjavaclass.svg", name="i18n::UserDefinedJavaClass.Name", description="i18n::UserDefinedJavaClass.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::UserDefinedJavaClassMeta.keyword"}, documentationUrl="/pipeline/transforms/userdefinedjavaclass.html")
public class UserDefinedJavaClassMeta
extends BaseTransformMeta<UserDefinedJavaClass, UserDefinedJavaClassData> {
    private static final Class<?> PKG = UserDefinedJavaClassMeta.class;
    @InjectionDeep
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    @InjectionDeep
    private List<UserDefinedJavaClassDef> definitions = new ArrayList<UserDefinedJavaClassDef>();
    public Class<TransformClassBase> cookedTransformClass;
    public List<Exception> cookErrors = new ArrayList<Exception>(0);
    private static final Cache<String, Class<?>> classCache;
    @Injection(name="CLEAR_RESULT_FIELDS")
    private boolean clearingResultFields;
    private boolean changed = true;
    @InjectionDeep
    private List<InfoTransformDefinition> infoTransformDefinitions = new ArrayList<InfoTransformDefinition>();
    @InjectionDeep
    private List<TargetTransformDefinition> targetTransformDefinitions = new ArrayList<TargetTransformDefinition>();
    @InjectionDeep
    private List<UsageParameter> usageParameters = new ArrayList<UsageParameter>();

    @VisibleForTesting
    Class<?> cookClass(UserDefinedJavaClassDef def, ClassLoader clsloader) throws CompileException, IOException, RuntimeException, HopTransformException {
        StringReader sr;
        String checksum = def.getChecksum();
        Class rtn = (Class)classCache.getIfPresent((Object)checksum);
        if (rtn != null) {
            return rtn;
        }
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        }
        ClassBodyEvaluator cbe = new ClassBodyEvaluator();
        if (clsloader == null) {
            cbe.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        } else {
            cbe.setParentClassLoader(clsloader);
        }
        cbe.setClassName(def.getClassName());
        if (def.isTransformClass()) {
            cbe.setExtendedType(TransformClassBase.class);
            sr = new StringReader(def.getTransformedSource());
        } else {
            sr = new StringReader(def.getSource());
        }
        cbe.setDefaultImports(new String[]{"org.apache.hop.pipeline.transforms.userdefinedjavaclass.*", "org.apache.hop.pipeline.transform.*", "org.apache.hop.core.row.*", "org.apache.hop.core.*", "org.apache.hop.core.exception.*", "org.apache.hop.pipeline.*", "org.apache.hop.workflow.*", "org.apache.hop.workflow.action.*", "org.apache.hop.core.plugins.*", "org.apache.hop.core.variables.*", "java.util.*"});
        cbe.cook(new Scanner(null, (Reader)sr));
        rtn = cbe.getClazz();
        classCache.put((Object)checksum, (Object)rtn);
        return rtn;
    }

    public void cookClasses() {
        this.cookErrors.clear();
        ClassLoader clsloader = UserDefinedJavaClass.class.getClassLoader();
        for (UserDefinedJavaClassDef def : this.getDefinitions()) {
            if (!def.isActive()) continue;
            try {
                Class<?> cookedClass = this.cookClass(def, clsloader);
                clsloader = cookedClass.getClassLoader();
                if (!def.isTransformClass()) continue;
                this.cookedTransformClass = cookedClass;
            }
            catch (Throwable e) {
                CompileException exception = new CompileException(e.getMessage(), null);
                exception.setStackTrace(new StackTraceElement[0]);
                this.cookErrors.add((Exception)exception);
            }
        }
        this.changed = false;
    }

    public TransformClassBase newChildInstance(UserDefinedJavaClass parent, UserDefinedJavaClassMeta meta, UserDefinedJavaClassData data) {
        if (!this.checkClassCookings(this.getLog())) {
            return null;
        }
        try {
            return this.cookedTransformClass.getConstructor(UserDefinedJavaClass.class, UserDefinedJavaClassMeta.class, UserDefinedJavaClassData.class).newInstance(new Object[]{parent, meta, data});
        }
        catch (Exception e) {
            if (this.log.isDebug()) {
                this.log.logError("Full debugging stacktrace of UserDefinedJavaClass instanciation exception:", e.getCause());
            }
            HopException hopException = new HopException(e.getMessage());
            hopException.setStackTrace(new StackTraceElement[0]);
            this.cookErrors.add((Exception)((Object)hopException));
            return null;
        }
    }

    public List<FieldInfo> getFieldInfo() {
        return Collections.unmodifiableList(this.fields);
    }

    public void setFieldInfo(List<FieldInfo> fields) {
        this.replaceFields(fields);
    }

    public void replaceFields(List<FieldInfo> fields) {
        this.fields = fields;
        this.changed = true;
    }

    public List<UserDefinedJavaClassDef> getDefinitions() {
        return Collections.unmodifiableList(this.definitions);
    }

    @VisibleForTesting
    protected List<UserDefinedJavaClassDef> orderDefinitions(List<UserDefinedJavaClassDef> definitions) {
        ArrayList<UserDefinedJavaClassDef> orderedDefinitions = new ArrayList<UserDefinedJavaClassDef>(definitions.size());
        List transactions = definitions.stream().filter(def -> def.isTransformClass() && def.isActive()).sorted((p1, p2) -> p1.getClassName().compareTo(p2.getClassName())).collect(Collectors.toList());
        List normalClasses = definitions.stream().filter(def -> !def.isTransformClass()).sorted((p1, p2) -> p1.getClassName().compareTo(p2.getClassName())).collect(Collectors.toList());
        orderedDefinitions.addAll(normalClasses);
        orderedDefinitions.addAll(transactions);
        return orderedDefinitions;
    }

    public void replaceDefinitions(List<UserDefinedJavaClassDef> definitions) {
        this.definitions.clear();
        this.definitions = this.orderDefinitions(definitions);
        this.changed = true;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        try {
            UserDefinedJavaClassMeta retval = (UserDefinedJavaClassMeta)((Object)super.clone());
            if (this.fields != null) {
                ArrayList<FieldInfo> newFields = new ArrayList<FieldInfo>(this.fields.size());
                for (FieldInfo fieldInfo : this.fields) {
                    newFields.add((FieldInfo)fieldInfo.clone());
                }
                retval.fields = newFields;
            }
            if (this.definitions != null) {
                ArrayList<UserDefinedJavaClassDef> newDefinitions = new ArrayList<UserDefinedJavaClassDef>();
                for (UserDefinedJavaClassDef userDefinedJavaClassDef : this.definitions) {
                    newDefinitions.add((UserDefinedJavaClassDef)userDefinedJavaClassDef.clone());
                }
                retval.definitions = newDefinitions;
            }
            retval.cookedTransformClass = null;
            retval.cookErrors = new ArrayList<Exception>(0);
            if (this.infoTransformDefinitions != null) {
                ArrayList<InfoTransformDefinition> newInfoTransformDefinitions = new ArrayList<InfoTransformDefinition>();
                for (InfoTransformDefinition infoTransformDefinition : this.infoTransformDefinitions) {
                    newInfoTransformDefinitions.add((InfoTransformDefinition)infoTransformDefinition.clone());
                }
                retval.infoTransformDefinitions = newInfoTransformDefinitions;
            }
            if (this.targetTransformDefinitions != null) {
                ArrayList<TargetTransformDefinition> newTargetTransformDefinitions = new ArrayList<TargetTransformDefinition>();
                for (TargetTransformDefinition targetTransformDefinition : this.targetTransformDefinitions) {
                    newTargetTransformDefinitions.add((TargetTransformDefinition)targetTransformDefinition.clone());
                }
                retval.targetTransformDefinitions = newTargetTransformDefinitions;
            }
            if (this.usageParameters != null) {
                ArrayList<UsageParameter> newUsageParameters = new ArrayList<UsageParameter>();
                for (UsageParameter usageParameter : this.usageParameters) {
                    newUsageParameters.add((UsageParameter)usageParameter.clone());
                }
                retval.usageParameters = newUsageParameters;
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node definitionsNode = XmlHandler.getSubNode((Node)transformNode, (String)ElementNames.definitions.name());
            int nrDefinitions = XmlHandler.countNodes((Node)definitionsNode, (String)ElementNames.definition.name());
            for (int i = 0; i < nrDefinitions; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)definitionsNode, (String)ElementNames.definition.name(), (int)i);
                UserDefinedJavaClassDef.ClassType classType = UserDefinedJavaClassDef.ClassType.valueOf(XmlHandler.getTagValue((Node)fnode, (String)ElementNames.class_type.name()));
                this.definitions.add(new UserDefinedJavaClassDef(classType, XmlHandler.getTagValue((Node)fnode, (String)ElementNames.class_name.name()), XmlHandler.getTagValue((Node)fnode, (String)ElementNames.class_source.name())));
            }
            this.definitions = this.orderDefinitions(this.definitions);
            Node fieldsNode = XmlHandler.getSubNode((Node)transformNode, (String)ElementNames.fields.name());
            int nrFields = XmlHandler.countNodes((Node)fieldsNode, (String)ElementNames.field.name());
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fieldsNode, (String)ElementNames.field.name(), (int)i);
                this.fields.add(new FieldInfo(XmlHandler.getTagValue((Node)fnode, (String)ElementNames.field_name.name()), ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)ElementNames.field_type.name())), Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)ElementNames.field_length.name()), (int)-1), Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)ElementNames.field_precision.name()), (int)-1)));
            }
            this.setClearingResultFields(!"N".equals(XmlHandler.getTagValue((Node)transformNode, (String)ElementNames.clear_result_fields.name())));
            this.infoTransformDefinitions.clear();
            Node infosNode = XmlHandler.getSubNode((Node)transformNode, (String)ElementNames.info_transforms.name());
            int nrInfos = XmlHandler.countNodes((Node)infosNode, (String)ElementNames.info_transform.name());
            for (int i = 0; i < nrInfos; ++i) {
                Node infoNode = XmlHandler.getSubNodeByNr((Node)infosNode, (String)ElementNames.info_transform.name(), (int)i);
                InfoTransformDefinition transformDefinition = new InfoTransformDefinition();
                transformDefinition.tag = XmlHandler.getTagValue((Node)infoNode, (String)ElementNames.transform_tag.name());
                transformDefinition.transformName = XmlHandler.getTagValue((Node)infoNode, (String)ElementNames.transform_name.name());
                transformDefinition.description = XmlHandler.getTagValue((Node)infoNode, (String)ElementNames.transform_description.name());
                this.infoTransformDefinitions.add(transformDefinition);
            }
            this.targetTransformDefinitions.clear();
            Node targetsNode = XmlHandler.getSubNode((Node)transformNode, (String)ElementNames.target_transforms.name());
            int nrTargets = XmlHandler.countNodes((Node)targetsNode, (String)ElementNames.target_transform.name());
            for (int i = 0; i < nrTargets; ++i) {
                Node targetNode = XmlHandler.getSubNodeByNr((Node)targetsNode, (String)ElementNames.target_transform.name(), (int)i);
                TargetTransformDefinition transformDefinition = new TargetTransformDefinition();
                transformDefinition.tag = XmlHandler.getTagValue((Node)targetNode, (String)ElementNames.transform_tag.name());
                transformDefinition.transformName = XmlHandler.getTagValue((Node)targetNode, (String)ElementNames.transform_name.name());
                transformDefinition.description = XmlHandler.getTagValue((Node)targetNode, (String)ElementNames.transform_description.name());
                this.targetTransformDefinitions.add(transformDefinition);
            }
            this.usageParameters.clear();
            Node parametersNode = XmlHandler.getSubNode((Node)transformNode, (String)ElementNames.usage_parameters.name());
            int nrParameters = XmlHandler.countNodes((Node)parametersNode, (String)ElementNames.usage_parameter.name());
            for (int i = 0; i < nrParameters; ++i) {
                Node parameterNode = XmlHandler.getSubNodeByNr((Node)parametersNode, (String)ElementNames.usage_parameter.name(), (int)i);
                UsageParameter usageParameter = new UsageParameter();
                usageParameter.tag = XmlHandler.getTagValue((Node)parameterNode, (String)ElementNames.parameter_tag.name());
                usageParameter.value = XmlHandler.getTagValue((Node)parameterNode, (String)ElementNames.parameter_value.name());
                usageParameter.description = XmlHandler.getTagValue((Node)parameterNode, (String)ElementNames.parameter_description.name());
                this.usageParameters.add(usageParameter);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
    }

    private boolean checkClassCookings(ILogChannel logChannel) {
        boolean ok;
        boolean bl = ok = this.cookedTransformClass != null && this.cookErrors.size() == 0;
        if (this.changed) {
            this.cookClasses();
            if (this.cookedTransformClass == null) {
                if (this.cookErrors.size() > 0) {
                    logChannel.logDebug(BaseMessages.getString(PKG, (String)"UserDefinedJavaClass.Exception.CookingError", (Object[])new Object[]{this.cookErrors.get(0)}));
                }
                ok = false;
            } else {
                ok = true;
            }
        }
        return ok;
    }

    public ITransformIOMeta getTransformIOMeta() {
        if (!this.checkClassCookings(this.getLog())) {
            return super.getTransformIOMeta();
        }
        try {
            Method getTransformIOMeta = this.cookedTransformClass.getMethod("getTransformIOMeta", UserDefinedJavaClassMeta.class);
            if (getTransformIOMeta != null) {
                ITransformIOMeta transformIoMeta = (ITransformIOMeta)getTransformIOMeta.invoke(null, new Object[]{this});
                if (transformIoMeta == null) {
                    return super.getTransformIOMeta();
                }
                return transformIoMeta;
            }
            return super.getTransformIOMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getTransformIOMeta();
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        for (InfoTransformDefinition infoTransformDefinition : this.infoTransformDefinitions) {
            infoTransformDefinition.transformMeta = TransformMeta.findTransform(transforms, (String)infoTransformDefinition.transformName);
        }
        for (TargetTransformDefinition targetTransformDefinition : this.targetTransformDefinitions) {
            targetTransformDefinition.transformMeta = TransformMeta.findTransform(transforms, (String)targetTransformDefinition.transformName);
        }
    }

    public void getFields(IRowMeta row, String originTransformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.checkClassCookings(this.getLog())) {
            if (this.cookErrors.size() > 0) {
                throw new HopTransformException("Error initializing UserDefinedJavaClass to get fields: ", (Throwable)this.cookErrors.get(0));
            }
            return;
        }
        try {
            Method getFieldsMethod = this.cookedTransformClass.getMethod("getFields", Boolean.TYPE, IRowMeta.class, String.class, IRowMeta[].class, TransformMeta.class, IVariables.class, List.class);
            getFieldsMethod.invoke(null, this.isClearingResultFields(), row, originTransformName, info, nextTransform, variables, this.getFieldInfo());
        }
        catch (Exception e) {
            throw new HopTransformException("Error executing UserDefinedJavaClass.getFields(): ", (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(String.format("\n    <%s>", ElementNames.definitions.name()));
        for (UserDefinedJavaClassDef userDefinedJavaClassDef : this.definitions) {
            retval.append(String.format("\n        <%s>", ElementNames.definition.name()));
            retval.append("\n        ").append(XmlHandler.addTagValue((String)ElementNames.class_type.name(), (String)userDefinedJavaClassDef.getClassType().name()));
            retval.append("\n        ").append(XmlHandler.addTagValue((String)ElementNames.class_name.name(), (String)userDefinedJavaClassDef.getClassName()));
            retval.append("\n        ");
            retval.append(XmlHandler.addTagValue((String)ElementNames.class_source.name(), (String)userDefinedJavaClassDef.getSource()));
            retval.append(String.format("\n        </%s>", ElementNames.definition.name()));
        }
        retval.append(String.format("\n    </%s>", ElementNames.definitions.name()));
        retval.append(String.format("\n    <%s>", ElementNames.fields.name()));
        for (FieldInfo fieldInfo : this.fields) {
            retval.append(String.format("\n        <%s>", ElementNames.field.name()));
            retval.append("\n        ").append(XmlHandler.addTagValue((String)ElementNames.field_name.name(), (String)fieldInfo.name));
            retval.append("\n        ").append(XmlHandler.addTagValue((String)ElementNames.field_type.name(), (String)ValueMetaFactory.getValueMetaName((int)fieldInfo.type)));
            retval.append("\n        ").append(XmlHandler.addTagValue((String)ElementNames.field_length.name(), (int)fieldInfo.length));
            retval.append("\n        ").append(XmlHandler.addTagValue((String)ElementNames.field_precision.name(), (int)fieldInfo.precision));
            retval.append(String.format("\n        </%s>", ElementNames.field.name()));
        }
        retval.append(String.format("\n    </%s>", ElementNames.fields.name()));
        retval.append(XmlHandler.addTagValue((String)ElementNames.clear_result_fields.name(), (boolean)this.clearingResultFields));
        retval.append(XmlHandler.openTag((String)ElementNames.info_transforms.name()));
        for (InfoTransformDefinition infoTransformDefinition : this.infoTransformDefinitions) {
            retval.append(XmlHandler.openTag((String)ElementNames.info_transform.name()));
            retval.append(XmlHandler.addTagValue((String)ElementNames.transform_tag.name(), (String)infoTransformDefinition.tag));
            retval.append(XmlHandler.addTagValue((String)ElementNames.transform_name.name(), infoTransformDefinition.transformMeta != null ? infoTransformDefinition.transformMeta.getName() : null));
            retval.append(XmlHandler.addTagValue((String)ElementNames.transform_description.name(), (String)infoTransformDefinition.description));
            retval.append(XmlHandler.closeTag((String)ElementNames.info_transform.name()));
        }
        retval.append(XmlHandler.closeTag((String)ElementNames.info_transforms.name()));
        retval.append(XmlHandler.openTag((String)ElementNames.target_transforms.name()));
        for (TargetTransformDefinition targetTransformDefinition : this.targetTransformDefinitions) {
            retval.append(XmlHandler.openTag((String)ElementNames.target_transform.name()));
            retval.append(XmlHandler.addTagValue((String)ElementNames.transform_tag.name(), (String)targetTransformDefinition.tag));
            retval.append(XmlHandler.addTagValue((String)ElementNames.transform_name.name(), targetTransformDefinition.transformMeta != null ? targetTransformDefinition.transformMeta.getName() : null));
            retval.append(XmlHandler.addTagValue((String)ElementNames.transform_description.name(), (String)targetTransformDefinition.description));
            retval.append(XmlHandler.closeTag((String)ElementNames.target_transform.name()));
        }
        retval.append(XmlHandler.closeTag((String)ElementNames.target_transforms.name()));
        retval.append(XmlHandler.openTag((String)ElementNames.usage_parameters.name()));
        for (UsageParameter usageParameter : this.usageParameters) {
            retval.append(XmlHandler.openTag((String)ElementNames.usage_parameter.name()));
            retval.append(XmlHandler.addTagValue((String)ElementNames.parameter_tag.name(), (String)usageParameter.tag));
            retval.append(XmlHandler.addTagValue((String)ElementNames.parameter_value.name(), (String)usageParameter.value));
            retval.append(XmlHandler.addTagValue((String)ElementNames.parameter_description.name(), (String)usageParameter.description));
            retval.append(XmlHandler.closeTag((String)ElementNames.usage_parameter.name()));
        }
        retval.append(XmlHandler.closeTag((String)ElementNames.usage_parameters.name()));
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.CheckResult.ConnectedTransformOK2", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isClearingResultFields() {
        return this.clearingResultFields;
    }

    public void setClearingResultFields(boolean clearingResultFields) {
        this.clearingResultFields = clearingResultFields;
    }

    public List<InfoTransformDefinition> getInfoTransformDefinitions() {
        return this.infoTransformDefinitions;
    }

    public void setInfoTransformDefinitions(List<InfoTransformDefinition> infoTransformDefinitions) {
        this.infoTransformDefinitions = infoTransformDefinitions;
    }

    public List<TargetTransformDefinition> getTargetTransformDefinitions() {
        return this.targetTransformDefinitions;
    }

    public void setTargetTransformDefinitions(List<TargetTransformDefinition> targetTransformDefinitions) {
        this.targetTransformDefinitions = targetTransformDefinitions;
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public List<UsageParameter> getUsageParameters() {
        return this.usageParameters;
    }

    public void setUsageParameters(List<UsageParameter> usageParameters) {
        this.usageParameters = usageParameters;
    }

    static {
        Variables vs = new Variables();
        vs.initializeFrom(null);
        String maxSizeStr = vs.getVariable("HOP_DEFAULT_CLASS_CACHE_SIZE", "100");
        int maxCacheSize = -1;
        try {
            maxCacheSize = Integer.parseInt(maxSizeStr);
        }
        catch (Exception ignored) {
            maxCacheSize = 100;
        }
        classCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
    }

    public static class FieldInfo
    implements Cloneable {
        @Injection(name="FIELD_NAME", group="FIELD_INFO")
        public final String name;
        @Injection(name="FIELD_TYPE", group="FIELD_INFO", convertEmpty=true, converter=DataTypeConverter.class)
        public final int type;
        @Injection(name="FIELD_LENGTH", group="FIELD_INFO", convertEmpty=true, converter=NullNumberConverter.class)
        public final int length;
        @Injection(name="FIELD_PRECISION", group="FIELD_INFO", convertEmpty=true, converter=NullNumberConverter.class)
        public final int precision;

        public FieldInfo() {
            this(null, 2, -1, -1);
        }

        public FieldInfo(String name, int type, int length, int precision) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.precision = precision;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static enum ElementNames {
        class_type,
        class_name,
        class_source,
        definitions,
        definition,
        fields,
        field,
        field_name,
        field_type,
        field_length,
        field_precision,
        clear_result_fields,
        info_transforms,
        info_transform,
        info_,
        target_transforms,
        target_transform,
        target_,
        transform_tag,
        transform_name,
        transform_description,
        usage_parameters,
        usage_parameter,
        parameter_tag,
        parameter_value,
        parameter_description;

    }
}

