/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.coder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.row.value.ValueMetaAvroRecord;

public class HopRowCoder
extends AtomicCoder<HopRow> {
    public void encode(HopRow hopRow, OutputStream outStream) throws IOException {
        Object[] row = hopRow.getRow();
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        if (row == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(hopRow.length());
        for (int i = 0; i < hopRow.length(); ++i) {
            Object object = row[i];
            out.writeBoolean(object == null);
            if (object == null) continue;
            int objectType = this.getObjectType(object);
            out.writeInt(objectType);
            this.write(out, objectType, object);
        }
        out.flush();
    }

    public HopRow decode(InputStream inStream) throws IOException {
        ObjectInputStream in = new ObjectInputStream(inStream);
        Object[] row = null;
        int length = in.readInt();
        if (length < 0) {
            return new HopRow(row);
        }
        row = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object object;
            boolean isNull = in.readBoolean();
            if (isNull) continue;
            int objectType = in.readInt();
            row[i] = object = this.read(in, objectType);
        }
        return new HopRow(row, length);
    }

    public void verifyDeterministic() {
    }

    private void write(ObjectOutputStream out, int objectType, Object object) throws IOException {
        switch (objectType) {
            case 2: {
                String string = (String)object;
                byte[] data = string.getBytes(StandardCharsets.UTF_8);
                out.writeInt(data.length);
                out.write(data);
                break;
            }
            case 5: {
                Long lng = (Long)object;
                out.writeLong(lng);
                break;
            }
            case 9: {
                out.writeLong(((Timestamp)object).getTime());
                out.writeInt(((Timestamp)object).getNanos());
                break;
            }
            case 3: {
                long lng = ((Date)object).getTime();
                out.writeLong(lng);
                break;
            }
            case 4: {
                boolean b = (Boolean)object;
                out.writeBoolean(b);
                break;
            }
            case 1: {
                Double dbl = (Double)object;
                out.writeDouble(dbl);
                break;
            }
            case 6: {
                BigDecimal bd = (BigDecimal)object;
                out.writeUTF(bd.toString());
                break;
            }
            case 8: {
                byte[] bytes = (byte[])object;
                out.write(bytes.length);
                out.write(bytes);
                break;
            }
            case 10: {
                InetAddress inetAddress = (InetAddress)object;
                this.write(out, 2, inetAddress.getHostName());
                out.writeInt(inetAddress.getAddress().length == 4 ? 1 : 2);
                out.write(inetAddress.getAddress());
                break;
            }
            case 20: {
                GenericRecord genericRecord = (GenericRecord)object;
                try {
                    out.writeUTF(genericRecord.getSchema().toString(false));
                    ValueMetaAvroRecord valueMeta = new ValueMetaAvroRecord("write", genericRecord.getSchema());
                    DataOutputStream dataOutputStream = new DataOutputStream(out);
                    valueMeta.writeData(dataOutputStream, (Object)genericRecord);
                    dataOutputStream.flush();
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Error serializing Avro generic schema and record to String", e);
                }
            }
            default: {
                throw new IOException("Data type not supported yet: " + objectType + " - " + object.toString());
            }
        }
    }

    private Object read(ObjectInputStream in, int objectType) throws IOException {
        switch (objectType) {
            case 2: {
                int length = in.readInt();
                byte[] data = new byte[length];
                in.readFully(data);
                return new String(data, StandardCharsets.UTF_8);
            }
            case 5: {
                return in.readLong();
            }
            case 9: {
                Timestamp timestamp = new Timestamp(in.readLong());
                timestamp.setNanos(in.readInt());
                return timestamp;
            }
            case 3: {
                return new Date(in.readLong());
            }
            case 4: {
                return in.readBoolean();
            }
            case 1: {
                return in.readDouble();
            }
            case 6: {
                return new BigDecimal(in.readUTF());
            }
            case 8: {
                byte[] bytes = new byte[in.readInt()];
                in.read(bytes);
                return bytes;
            }
            case 10: {
                String hostname = (String)this.read(in, 2);
                byte[] addr = new byte[in.readInt() == 1 ? 4 : 16];
                in.read(addr);
                return InetAddress.getByAddress(hostname, addr);
            }
            case 20: {
                try {
                    String schemaJson = in.readUTF();
                    Schema schema = new Schema.Parser().parse(schemaJson);
                    ValueMetaAvroRecord valueMeta = new ValueMetaAvroRecord("read", schema);
                    DataInputStream dataInputStream = new DataInputStream(in);
                    GenericRecord genericRecord = (GenericRecord)valueMeta.readData(dataInputStream);
                    return genericRecord;
                }
                catch (Exception e) {
                    throw new IOException("Error de-serializing Avro schema and generic record from JSON", e);
                }
            }
        }
        throw new IOException("Data type not supported yet: " + objectType);
    }

    private int getObjectType(Object object) throws CoderException {
        if (object instanceof String) {
            return 2;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Timestamp) {
            return 9;
        }
        if (object instanceof Date) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 4;
        }
        if (object instanceof Double) {
            return 1;
        }
        if (object instanceof BigDecimal) {
            return 6;
        }
        if (object instanceof byte[]) {
            return 8;
        }
        if (object instanceof InetAddress) {
            return 10;
        }
        if (object instanceof GenericRecord) {
            return 20;
        }
        throw new CoderException("Data type for object class " + object.getClass().getName() + " isn't supported yet");
    }
}

