/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mozilla.universalchardet.UniversalDetector;

public class EncodingDetector {
    public static Charset detectEncoding(InputStream inputStream, Charset defaultCharset, long limitSize) throws IOException {
        String charsetName;
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buf = new byte[4096];
        try {
            int bytesRead = 0;
            for (long totalBytesRead = 0L; !(limitSize > 0L && totalBytesRead > limitSize || (bytesRead = inputStream.read(buf)) <= 0 || detector.isDone()); totalBytesRead += (long)bytesRead) {
                detector.handleData(buf, 0, bytesRead);
            }
            detector.isDone();
            detector.handleData(buf, 0, bytesRead);
            detector.dataEnd();
            charsetName = detector.getDetectedCharset();
            detector.reset();
        }
        catch (Throwable e) {
            charsetName = null;
        }
        if (charsetName != null && Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        return defaultCharset;
    }
}

