/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

class SystemValueUtility {
    static boolean jdk14 = false;

    SystemValueUtility() {
    }

    private static Vector parse(byte[] byArray, AS400 aS400, Converter converter) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException {
        Vector<String[]> vector = new Vector<String[]>();
        int n = BinaryConverter.byteArrayToInt(byArray, 0);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Number of values:", n);
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = BinaryConverter.byteArrayToInt(byArray, (i + 1) * 4);
            String string = converter.byteArrayToString(byArray, n4, 10).trim();
            SystemValueInfo systemValueInfo = SystemValueList.lookup(string);
            if (byArray[n4 + 11] == -45) {
                Trace.log(2, "System value is locked, name: " + string);
                throw new ExtendedIOException(string, 33);
            }
            if (byArray[n4 + 10] != systemValueInfo.serverDataType_) {
                Trace.log(2, "System value type mismatch, name: " + string);
                throw new ExtendedIllegalStateException("type", 4);
            }
            int n5 = BinaryConverter.byteArrayToInt(byArray, n4 + 12);
            Object object = null;
            switch (systemValueInfo.serverDataType_) {
                case -61: {
                    if (systemValueInfo.type_ == 4) {
                        n3 = n4 + 16;
                        for (n2 = 0; n2 < systemValueInfo.arraySize_ && byArray[n3 + n2 * systemValueInfo.size_] != 64; ++n2) {
                        }
                        String[] stringArray = new String[n2];
                        for (int j = 0; j < n2; ++j) {
                            stringArray[j] = converter.byteArrayToString(byArray, n3 + j * systemValueInfo.size_, systemValueInfo.size_);
                        }
                        object = stringArray;
                        break;
                    }
                    object = converter.byteArrayToString(byArray, n4 + 16, n5);
                    break;
                }
                case -62: {
                    if (systemValueInfo.type_ == 2) {
                        byte[] byArray2 = new byte[4];
                        System.arraycopy(byArray, n4 + 16, byArray2, 0, 4);
                        object = new BigDecimal(new BigInteger(byArray2), systemValueInfo.decimalPositions_);
                        break;
                    }
                    object = new Integer(BinaryConverter.byteArrayToInt(byArray, n4 + 16));
                    break;
                }
                default: {
                    Trace.log(4, "Invalid value for SystemValueInfo.serverDataType_: " + systemValueInfo.serverDataType_);
                }
            }
            if (systemValueInfo.name_.equals("QDATE")) {
                String string2 = object.toString();
                Calendar calendar = AS400Calendar.getGregorianInstance();
                calendar.set(1900 + 100 * Integer.parseInt(string2.substring(0, 1)) + Integer.parseInt(string2.substring(1, 3)), Integer.parseInt(string2.substring(3, 5)) - 1, Integer.parseInt(string2.substring(5, 7)));
                long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
                object = new Date(l);
            } else if (systemValueInfo.name_.equals("QTIME")) {
                String string3 = object.toString();
                Calendar calendar = AS400Calendar.getGregorianInstance();
                calendar.set(11, Integer.parseInt(string3.substring(0, 2)));
                calendar.set(12, Integer.parseInt(string3.substring(2, 4)));
                calendar.set(13, Integer.parseInt(string3.substring(4, 6)));
                calendar.set(14, Integer.parseInt(string3.substring(6, 9)));
                long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
                object = new Time(l);
            } else if (systemValueInfo.name_.equals("PNDSYSNAME")) {
                object = ((String)object).replace('\u0000', ' ');
            } else if (systemValueInfo.name_.equals("QLOCALE")) {
                n2 = n4 + 16;
                n3 = BinaryConverter.byteArrayToInt(byArray, n2);
                int n6 = BinaryConverter.byteArrayToInt(byArray, n2 + 16);
                object = n6 == 0 ? "*NONE" : (n6 == 1 ? converter.byteArrayToString(byArray, n2 + 32, 20) : new Converter(n3, aS400).byteArrayToString(byArray, n2 + 32, n6));
            }
            vector.addElement((String[])object);
        }
        return vector;
    }

    static Object retrieve(AS400 aS400, SystemValueInfo systemValueInfo) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Vector<SystemValueInfo> vector = new Vector<SystemValueInfo>();
        vector.addElement(systemValueInfo);
        Vector vector2 = SystemValueUtility.retrieveFromSystem(aS400, vector, systemValueInfo.group_ == 8);
        return vector2.elementAt(0);
    }

    static Vector retrieve(AS400 aS400, Enumeration enumeration, String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        Serializable serializable;
        Vector<SystemValueInfo> vector = new Vector<SystemValueInfo>();
        Vector<SystemValueInfo> vector2 = new Vector<SystemValueInfo>();
        int n2 = aS400.getVRM();
        while (enumeration.hasMoreElements()) {
            serializable = (SystemValueInfo)enumeration.nextElement();
            if (((SystemValueInfo)serializable).release_ > n2) continue;
            if (((SystemValueInfo)serializable).group_ == 8) {
                vector2.addElement((SystemValueInfo)serializable);
                continue;
            }
            vector.addElement((SystemValueInfo)serializable);
        }
        serializable = new Vector();
        Vector vector3 = new Vector();
        if (vector.size() > 0) {
            serializable = SystemValueUtility.retrieveFromSystem(aS400, vector, false);
        }
        if (vector2.size() > 0) {
            vector3 = SystemValueUtility.retrieveFromSystem(aS400, vector2, true);
        }
        Vector<SystemValue> vector4 = new Vector<SystemValue>(vector.size() + vector2.size());
        for (n = 0; n < vector.size(); ++n) {
            vector4.addElement(new SystemValue(aS400, (SystemValueInfo)vector.elementAt(n), ((Vector)serializable).elementAt(n), string, string2));
        }
        for (n = 0; n < vector2.size(); ++n) {
            vector4.addElement(new SystemValue(aS400, (SystemValueInfo)vector2.elementAt(n), vector3.elementAt(n), string, string2));
        }
        return vector4;
    }

    static Vector retrieveFromSystem(AS400 aS400, Vector vector, boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Serializable serializable;
        int n = vector.size();
        int n2 = 4;
        byte[] byArray = new byte[n * 10];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 64;
        }
        Converter converter = new Converter(aS400.getJobCcsid(), aS400);
        for (int i = 0; i < n; ++i) {
            serializable = (SystemValueInfo)vector.elementAt(i);
            n2 += ((SystemValueInfo)serializable).size_ * ((SystemValueInfo)serializable).arraySize_ + 24;
            converter.stringToByteArray(((SystemValueInfo)serializable).name_, byArray, i * 10);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(BinaryConverter.intToByteArray(n)), new ProgramParameter(byArray), new ProgramParameter(new byte[8])};
        serializable = new ProgramCall(aS400, bl ? "/QSYS.LIB/QWCRNETA.PGM" : "/QSYS.LIB/QWCRSVAL.PGM", programParameterArray);
        ((ProgramCall)serializable).suggestThreadsafe();
        if (!((ProgramCall)serializable).run()) {
            throw new AS400Exception(((ProgramCall)serializable).getMessageList());
        }
        return SystemValueUtility.parse(programParameterArray[0].getOutputData(), aS400, converter);
    }

    static void set(AS400 aS400, SystemValueInfo systemValueInfo, Object object) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        Object object2;
        if (systemValueInfo.readOnly_) {
            Trace.log(2, "Cannot set value of read only system value, name: " + systemValueInfo.name_);
            throw new ExtendedIllegalStateException(systemValueInfo.name_, 12);
        }
        boolean bl = systemValueInfo.group_ == 8;
        StringBuffer stringBuffer = new StringBuffer(bl ? "QSYS/CHGNETA " + systemValueInfo.name_ + "(" : "QSYS/CHGSYSVAL SYSVAL(" + systemValueInfo.name_ + ") VALUE(");
        String string = object.toString();
        if (string.indexOf("*") == 0) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "System value's value is special star value: '" + (String)object + "'");
            }
            stringBuffer.append(string.trim());
        } else {
            try {
                switch (systemValueInfo.type_) {
                    case 1: {
                        stringBuffer.append(bl ? string : "'" + string + "'");
                        break;
                    }
                    case 2: {
                        stringBuffer.append(((BigDecimal)object).setScale(systemValueInfo.decimalPositions_, 4).toString());
                        break;
                    }
                    case 3: {
                        stringBuffer.append(((Integer)object).toString());
                        break;
                    }
                    case 4: {
                        object2 = (Object[])object;
                        int n = ((Object[])object2).length;
                        if (!bl) {
                            stringBuffer.append("'");
                        }
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.append((String)object2[i]);
                            stringBuffer.append(" ");
                        }
                        if (!bl) {
                            stringBuffer.append("'");
                        }
                        break;
                    }
                    case 5: {
                        Calendar calendar = AS400Calendar.getGregorianInstance();
                        calendar.clear();
                        calendar.setTime((java.util.Date)object);
                        if (systemValueInfo.name_.equals("QDATE")) {
                            String string2;
                            String string3;
                            String string4;
                            String string5;
                            int n = calendar.get(1);
                            if (n < 1900 || n > 2100) {
                                Trace.log(2, "Value of system value 'QYEAR' is not valid:", n);
                                throw new ExtendedIllegalArgumentException("QYEAR  (" + n + ")", 4);
                            }
                            if (n < 2000) {
                                string5 = "0";
                                string4 = Integer.toString(n - 1900);
                            } else {
                                string5 = "1";
                                string4 = Integer.toString(n - 2000);
                            }
                            if (string4.length() == 1) {
                                string4 = "0" + string4;
                            }
                            if ((string3 = Integer.toString(calendar.get(2) + 1)).length() == 1) {
                                string3 = "0" + string3;
                            }
                            if ((string2 = Integer.toString(calendar.get(5))).length() == 1) {
                                string2 = "0" + string2;
                            }
                            SystemValueUtility.set(aS400, SystemValueList.lookup("QCENTURY"), string5);
                            SystemValueUtility.set(aS400, SystemValueList.lookup("QYEAR"), string4);
                            SystemValueUtility.set(aS400, SystemValueList.lookup("QMONTH"), string3);
                            SystemValueUtility.set(aS400, SystemValueList.lookup("QDAY"), string2);
                            return;
                        }
                        stringBuffer.append("'");
                        int n = calendar.get(11);
                        if (n < 10) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(Integer.toString(n));
                        int n2 = calendar.get(12);
                        if (n2 < 10) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(Integer.toString(n2));
                        int n3 = calendar.get(13);
                        if (n3 < 10) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(Integer.toString(n3));
                        stringBuffer.append("'");
                        break;
                    }
                    default: {
                        Trace.log(2, "Invalid value for SystemValueInfo.type_: " + systemValueInfo.type_);
                        throw new InternalErrorException(6);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                Trace.log(2, "Cannot set system value, value is of incorrect type, name: " + systemValueInfo.name_ + ", value: " + object, (Throwable)classCastException);
                throw new ExtendedIllegalArgumentException(systemValueInfo.name_, 2);
            }
        }
        stringBuffer.append(")");
        object2 = new CommandCall(aS400, stringBuffer.toString());
        ((CommandCall)object2).suggestThreadsafe(false);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Running system value command: " + stringBuffer.toString());
        }
        if (!((CommandCall)object2).run()) {
            throw new AS400Exception(((CommandCall)object2).getMessageList());
        }
    }

    static {
        jdk14 = JVMInfo.isJDK14();
    }
}

