/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNClobLocator
implements SQLLocator {
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private String savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;

    SQLNClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, true);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLNClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        int n = this.scale_;
        if (n == -1) {
            try {
                n = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof Reader) {
            this.value_ = SQLDataBase.getStringFromReader((Reader)object, n, this);
            this.savedObject_ = this.value_;
        } else if (object instanceof Clob) {
            Clob clob;
            if (object instanceof AS400JDBCClobLocator) {
                Clob clob2 = clob = (AS400JDBCClobLocator)object;
                synchronized (clob2) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        if (!(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            clob = (Clob)object;
            this.value_ = clob.getSubString(1L, (int)clob.length());
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n2 = this.value_.length();
        if (n2 > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeToServer() throws SQLException {
        block52: {
            try {
                var1_1 = this.savedObject_;
                if (var1_1 instanceof String) {
                    var2_2 = (String)var1_1;
                    var3_6 = this.converter_.stringToByteArray(var2_2);
                    this.locator_.writeData(0L, var3_6, true);
                    break block52;
                }
                if (var1_1 instanceof Reader) {
                    var2_3 = this.scale_ * 2;
                    if (var2_3 == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block52;
                    }
                    if (var2_3 > 0) {
                        try {
                            var3_7 = var2_3 < 1000000 ? var2_3 : 1000000;
                            var4_14 = this.settings_.getBidiStringType();
                            if (var4_14 == -1) {
                                var4_14 = this.converter_.bidiStringType_;
                            }
                            var5_20 = new BidiConversionProperties(var4_14);
                            var5_20.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            var5_20.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            var6_25 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_20, var3_7);
                            try {
                                var7_32 = new byte[var3_7];
                                var8_37 = 0;
                                var9_41 = var6_25.read(var7_32, 0, var3_7);
                                while (var9_41 > -1 && var8_37 < var2_3) {
                                    this.locator_.writeData(var8_37 / 2, var7_32, 0, var9_41, true);
                                    var10_43 = var2_3 - (var8_37 += var9_41);
                                    if (var10_43 < var3_7) {
                                        var3_7 = var10_43;
                                        if (var6_25.available() == 0 && var3_7 != 0) {
                                            var6_25.close();
                                            var6_25 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_20, var3_7);
                                        }
                                    }
                                    var9_41 = var6_25.read(var7_32, 0, var3_7);
                                }
                                if (var8_37 < var2_3) {
                                    JDError.throwSQLException((Object)this, "07006");
                                }
                                var12_44 = null;
                            }
                            catch (Throwable var11_48) {
                                var12_45 = null;
                                try {
                                    var6_25.close();
                                }
                                catch (Exception var13_47) {
                                    JDTrace.logException(this, "writeToServer stream.close()", var13_47);
                                }
                                throw var11_48;
                            }
                            try {
                                var6_25.close();
                            }
                            catch (Exception var13_46) {
                                JDTrace.logException(this, "writeToServer stream.close()", var13_46);
                            }
                            break block52;
                        }
                        catch (IOException var3_8) {
                            JDError.throwSQLException((Object)this, "HY000", var3_8);
                        }
                        break block52;
                    }
                    if (var2_3 == -2) {
                        try {
                            var3_9 = 1000000;
                            var4_15 = this.settings_.getBidiStringType();
                            if (var4_15 == -1) {
                                var4_15 = this.converter_.bidiStringType_;
                            }
                            var5_21 = new BidiConversionProperties(var4_15);
                            var5_21.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            var5_21.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            var6_26 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_21, var3_9);
                            try {
                                var7_33 = new byte[var3_9];
                                var8_38 = 0;
                                var9_42 = var6_26.read(var7_33, 0, var3_9);
                                while (var9_42 > -1) {
                                    this.locator_.writeData(var8_38 / 2, var7_33, 0, var9_42, true);
                                    var8_38 += var9_42;
                                    var9_42 = var6_26.read(var7_33, 0, var3_9);
                                }
                                var15_49 = null;
                            }
                            catch (Throwable var14_53) {
                                var15_50 = null;
                                try {
                                    var6_26.close();
                                }
                                catch (Exception var16_52) {
                                    JDTrace.logException(this, "writeToServer stream2.close()", var16_52);
                                }
                                throw var14_53;
                            }
                            try {
                                var6_26.close();
                            }
                            catch (Exception var16_51) {
                                JDTrace.logException(this, "writeToServer stream2.close()", var16_51);
                            }
                            break block52;
                        }
                        catch (IOException var3_10) {
                            JDError.throwSQLException((Object)this, "HY000", var3_10);
                        }
                        break block52;
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block52;
                }
                if (var1_1 instanceof InputStream) {
                    var2_4 = this.scale_ * 2;
                    if (var2_4 == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block52;
                    }
                    if (var2_4 > 0) {
                        var3_11 = (InputStream)this.savedObject_;
                        var4_16 = var2_4 < 1000000 ? var2_4 : 1000000;
                        var5_22 = new byte[var4_16];
                        try {
                            var6_27 = 0;
                            var7_34 = var3_11.read(var5_22, 0, var4_16);
                            while (var7_34 > -1 && var6_27 < var2_4) {
                                this.locator_.writeData((long)var6_27 / 2L, var5_22, 0, var7_34, true);
                                var8_39 = var2_4 - (var6_27 += var7_34);
                                if (var8_39 < var4_16) {
                                    var4_16 = var8_39;
                                }
                                var7_34 = var3_11.read(var5_22, 0, var4_16);
                            }
                            if (var6_27 < var2_4) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block52;
                        }
                        catch (IOException var6_28) {
                            JDError.throwSQLException((Object)this, "HY000", var6_28);
                        }
                        break block52;
                    }
                    if (var2_4 == -2) {
                        var3_12 = (InputStream)this.savedObject_;
                        var4_17 = 1000000;
                        var5_23 = new byte[var4_17];
                        try {
                            var6_29 = 0;
                            var7_35 = var3_12.read(var5_23, 0, var4_17);
                            while (var7_35 > -1) {
                                this.locator_.writeData((long)var6_29 / 2L, var5_23, 0, var7_35, true);
                                var6_29 += var7_35;
                                var7_35 = var3_12.read(var5_23, 0, var4_17);
                            }
                            break block52;
                        }
                        catch (IOException var6_30) {
                            JDError.throwSQLException((Object)this, "HY000", var6_30);
                            break block52;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block52;
                }
                if (var1_1 instanceof Clob) {
                    var2_5 = false;
                    if (var1_1 instanceof AS400JDBCClobLocator) {
                        var3_13 = (AS400JDBCClobLocator)var1_1;
                        var4_18 = var3_13;
                        synchronized (var4_18) {
                            block53: {
                                if (var3_13.savedObject_ == null) break block53;
                                this.savedObject_ = var3_13.savedObject_;
                                this.savedObjectWrittenToServer_ = false;
                                this.scale_ = var3_13.savedScale_;
                                var3_13.savedObject_ = null;
                                this.writeToServer();
                                this.savedObjectWrittenToServer_ = false;
                                return;
                            }
                            ** try [egrp 11[TRYBLOCK] [11 : 960->966)] { 
                            {
                            }
                        }
                    }
lbl174:
                    // 3 sources

                    if (!var2_5) {
                        var3_13 = (Clob)var1_1;
                        var4_19 = (int)var3_13.length();
                        if (var4_19 < (var5_24 = 1000000)) {
                            var5_24 = var4_19;
                        }
                        var6_31 = 1;
                        var7_36 = new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
                        while (var6_31 <= var4_19) {
                            var8_40 = var3_13.getSubString(var6_31, var5_24);
                            var7_36.setString(var6_31, var8_40);
                            if (var4_19 - (var6_31 += var5_24) >= var5_24) continue;
                            var5_24 = var4_19 - var6_31 + 1;
                        }
                        var2_5 = true;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block52;
                }
                JDError.throwSQLException((Object)this, "07006");
            }
            finally {
                this.savedObjectWrittenToServer_ = true;
            }
        }
        this.scale_ = (int)this.locator_.getLength();
    }

    public int getSQLType() {
        return 34;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCNClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "NCLOB";
    }

    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 968;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "NCLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
            }
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

