/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDBClob
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int length_ = 0;
    private int maxLength_;
    private String value_;
    private Object savedObject_;
    private int ccsid_;

    SQLDBClob(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.maxLength_ = n;
        this.value_ = "";
    }

    public Object clone() {
        SQLDBClob sQLDBClob = new SQLDBClob(this.maxLength_, this.settings_);
        sQLDBClob.setCcsid(this.ccsid_);
        return sQLDBClob;
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToInt(byArray, n);
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.value_ = convTable.byteArrayToString(byArray, n + 4, this.length_ * 2, bidiConversionProperties);
        this.savedObject_ = null;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        BinaryConverter.intToByteArray(this.length_, byArray, n);
        try {
            int n2 = this.settings_.getBidiStringType();
            if (n2 == -1) {
                n2 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            convTable.stringToByteArray(this.value_, byArray, n + 4, this.maxLength_, bidiConversionProperties);
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length() * 2;
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.length_ = n != -1 ? n : -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        try {
            Object object = this.savedObject_;
            if (this.savedObject_ instanceof String) {
                this.value_ = (String)object;
            } else if (object instanceof Reader) {
                this.value_ = SQLDataBase.getStringFromReader((Reader)object, this.length_, this);
            } else if (object instanceof Clob) {
                Clob clob = (Clob)object;
                this.value_ = clob.getSubString(1L, (int)clob.length());
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
            int n = this.value_.length();
            if (n > this.maxLength_ / 2) {
                this.value_ = this.value_.substring(0, this.maxLength_ / 2);
                this.truncated_ = n - this.maxLength_ / 2;
                this.outOfBounds_ = false;
            } else {
                this.truncated_ = 0;
                this.outOfBounds_ = false;
            }
            this.length_ = this.value_.length();
        }
        finally {
            this.savedObject_ = null;
        }
    }

    public int getSQLType() {
        return 11;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClob";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "DBCLOB";
    }

    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 412;
    }

    public int getPrecision() {
        return this.maxLength_ / 2;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        if (this.ccsid_ == 1200) {
            return "NCLOB";
        }
        return "DBCLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.value_));
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.value_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(this.value_);
    }

    public Clob getClob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClob(this.value_, this.maxLength_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClob(this.value_, this.maxLength_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(this.value_);
    }

    public String getNString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public void setCcsid(int n) {
        this.ccsid_ = n;
    }

    public void saveValue() throws SQLException {
        if (this.savedObject_ != null && (this.value_ == null || this.value_.length() == 0)) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }
}

