/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataStreamException;
import java.math.BigDecimal;

class DBReplySQLCA {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;
    private int length_;
    private static final int[] locationFromOffset_ = new int[]{96, 100, 104, 108, 112, 116};

    public DBReplySQLCA(byte[] byArray, int n, int n2) {
        this.data_ = byArray;
        this.offset_ = n;
        this.length_ = n2;
    }

    public final int getErrd(int n) throws DBDataStreamException {
        if (this.length_ <= 6) {
            return 0;
        }
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + locationFromOffset_[n - 1]);
    }

    public final String getErrmc(ConvTable convTable) throws DBDataStreamException {
        if (this.length_ <= 6) {
            return "";
        }
        short s = BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 16);
        return convTable.byteArrayToString(this.data_, this.offset_ + 18, s);
    }

    public final String getErrp(ConvTable convTable) {
        int n = 8;
        if (this.length_ <= this.offset_ + 88) {
            return "";
        }
        if (this.length_ < this.offset_ + 88 + n) {
            n = this.length_ - this.offset_ - 88;
        }
        return convTable.byteArrayToString(this.data_, this.offset_ + 88, n);
    }

    public final String getErrmc(int n, ConvTable convTable) throws DBDataStreamException {
        short s;
        if (this.length_ <= 6) {
            return "";
        }
        int n2 = BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 16);
        int n3 = 1;
        int n4 = this.offset_ + 18;
        for (int i = 0; n3 < n && i < n2; i += s) {
            ++n3;
            s = (short)(BinaryConverter.byteArrayToShort(this.data_, n4) + 2);
            n4 += s;
        }
        s = BinaryConverter.byteArrayToShort(this.data_, n4);
        return convTable.byteArrayToString(this.data_, n4 + 2, s);
    }

    public final boolean getEyecatcherBit54() throws DBDataStreamException {
        if (this.length_ <= 6) {
            return false;
        }
        byte by = this.data_[this.offset_ + 6];
        return (by & 2) > 0;
    }

    public final BigDecimal getGeneratedKey() {
        AS400PackedDecimal aS400PackedDecimal = new AS400PackedDecimal(30, 0);
        try {
            return (BigDecimal)aS400PackedDecimal.toObject(this.data_, this.offset_ + 72);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public final int getSQLCode() throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 12);
    }

    public final String getSQLState(ConvTable convTable) throws DBDataStreamException {
        if (this.length_ <= 6) {
            return null;
        }
        return convTable.byteArrayToString(this.data_, this.offset_ + 131, 5);
    }

    public final byte getWarn5() throws DBDataStreamException {
        if (this.length_ <= 6) {
            return 0;
        }
        return this.data_[this.offset_ + 124];
    }
}

