/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.transform.MorePartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.service.reads.ShortReadPartitionsProtection;

public class ShortReadProtection {
    public static UnfilteredPartitionIterator extend(Replica source, Runnable preFetchCallback, UnfilteredPartitionIterator partitions, ReadCommand command, DataLimits.Counter mergedResultCounter, long queryStartNanoTime, boolean enforceStrictLiveness) {
        DataLimits.Counter singleResultCounter = command.limits().newCounter(command.nowInSec(), false, command.selectsFullPartition(), enforceStrictLiveness).onlyCount();
        ShortReadPartitionsProtection protection = new ShortReadPartitionsProtection(command, source, preFetchCallback, singleResultCounter, mergedResultCounter, queryStartNanoTime);
        if (!command.isLimitedToOnePartition()) {
            partitions = MorePartitions.extend(partitions, protection);
        }
        partitions = Transformation.apply(partitions, protection);
        partitions = Transformation.apply(partitions, singleResultCounter);
        return partitions;
    }
}

