/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.MerkleTrees;

public class ValidationTask
extends AbstractFuture<TreeResponse>
implements Runnable {
    private final RepairJobDesc desc;
    private final InetAddressAndPort endpoint;
    private final int nowInSec;
    private final PreviewKind previewKind;

    public ValidationTask(RepairJobDesc desc, InetAddressAndPort endpoint, int nowInSec, PreviewKind previewKind) {
        this.desc = desc;
        this.endpoint = endpoint;
        this.nowInSec = nowInSec;
        this.previewKind = previewKind;
    }

    @Override
    public void run() {
        RepairMessage.sendMessageWithFailureCB(new ValidationRequest(this.desc, this.nowInSec), Verb.VALIDATION_REQ, this.endpoint, arg_0 -> ((ValidationTask)this).setException(arg_0));
    }

    public void treesReceived(MerkleTrees trees) {
        if (trees == null) {
            this.setException(new RepairException(this.desc, this.previewKind, "Validation failed in " + this.endpoint));
        } else {
            this.set(new TreeResponse(this.endpoint, trees));
        }
    }
}

