/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.apache.cassandra.batchlog.Batch;
import org.apache.cassandra.batchlog.BatchRemoveVerbHandler;
import org.apache.cassandra.batchlog.BatchStoreVerbHandler;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.CounterMutationVerbHandler;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.MutationVerbHandler;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadCommandVerbHandler;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.db.TruncateRequest;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.db.TruncateVerbHandler;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.GossipDigestAck2VerbHandler;
import org.apache.cassandra.gms.GossipDigestAckVerbHandler;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.gms.GossipDigestSynVerbHandler;
import org.apache.cassandra.gms.GossipShutdownVerbHandler;
import org.apache.cassandra.hints.HintMessage;
import org.apache.cassandra.hints.HintVerbHandler;
import org.apache.cassandra.io.IVersionedAsymmetricSerializer;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.PingRequest;
import org.apache.cassandra.net.PingVerbHandler;
import org.apache.cassandra.net.ResponseVerbHandler;
import org.apache.cassandra.net.VerbTimeouts;
import org.apache.cassandra.repair.RepairMessageVerbHandler;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.FailSession;
import org.apache.cassandra.repair.messages.FinalizeCommit;
import org.apache.cassandra.repair.messages.FinalizePromise;
import org.apache.cassandra.repair.messages.FinalizePropose;
import org.apache.cassandra.repair.messages.PrepareConsistentRequest;
import org.apache.cassandra.repair.messages.PrepareConsistentResponse;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.SnapshotMessage;
import org.apache.cassandra.repair.messages.StatusRequest;
import org.apache.cassandra.repair.messages.StatusResponse;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.SyncResponse;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.repair.messages.ValidationResponse;
import org.apache.cassandra.schema.MigrationManager;
import org.apache.cassandra.schema.SchemaPullVerbHandler;
import org.apache.cassandra.schema.SchemaPushVerbHandler;
import org.apache.cassandra.schema.SchemaVersionVerbHandler;
import org.apache.cassandra.service.EchoVerbHandler;
import org.apache.cassandra.service.SnapshotVerbHandler;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.CommitVerbHandler;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.service.paxos.PrepareVerbHandler;
import org.apache.cassandra.service.paxos.ProposeVerbHandler;
import org.apache.cassandra.streaming.ReplicationDoneVerbHandler;
import org.apache.cassandra.utils.BooleanSerializer;
import org.apache.cassandra.utils.UUIDSerializer;

public enum Verb {
    MUTATION_RSP(60, Priority.P1, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    MUTATION_REQ(0, Priority.P3, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> Mutation.serializer, () -> MutationVerbHandler.instance, MUTATION_RSP),
    HINT_RSP(61, Priority.P1, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    HINT_REQ(1, Priority.P4, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> HintMessage.serializer, () -> HintVerbHandler.instance, HINT_RSP),
    READ_REPAIR_RSP(62, Priority.P1, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    READ_REPAIR_REQ(2, Priority.P1, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> Mutation.serializer, () -> ReadRepairVerbHandler.instance, READ_REPAIR_RSP),
    BATCH_STORE_RSP(65, Priority.P1, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    BATCH_STORE_REQ(5, Priority.P3, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> Batch.serializer, () -> BatchStoreVerbHandler.instance, BATCH_STORE_RSP),
    BATCH_REMOVE_RSP(66, Priority.P1, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    BATCH_REMOVE_REQ(6, Priority.P3, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> UUIDSerializer.serializer, () -> BatchRemoveVerbHandler.instance, BATCH_REMOVE_RSP),
    PAXOS_PREPARE_RSP(93, Priority.P2, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> PrepareResponse.serializer, () -> ResponseVerbHandler.instance),
    PAXOS_PREPARE_REQ(33, Priority.P2, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> Commit.serializer, () -> PrepareVerbHandler.instance, PAXOS_PREPARE_RSP),
    PAXOS_PROPOSE_RSP(94, Priority.P2, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> BooleanSerializer.serializer, () -> ResponseVerbHandler.instance),
    PAXOS_PROPOSE_REQ(34, Priority.P2, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> Commit.serializer, () -> ProposeVerbHandler.instance, PAXOS_PROPOSE_RSP),
    PAXOS_COMMIT_RSP(95, Priority.P2, VerbTimeouts.writeTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    PAXOS_COMMIT_REQ(35, Priority.P2, VerbTimeouts.writeTimeout, Stage.MUTATION, () -> Commit.serializer, () -> CommitVerbHandler.instance, PAXOS_COMMIT_RSP),
    TRUNCATE_RSP(79, Priority.P0, VerbTimeouts.truncateTimeout, Stage.REQUEST_RESPONSE, () -> TruncateResponse.serializer, () -> ResponseVerbHandler.instance),
    TRUNCATE_REQ(19, Priority.P0, VerbTimeouts.truncateTimeout, Stage.MUTATION, () -> TruncateRequest.serializer, () -> TruncateVerbHandler.instance, TRUNCATE_RSP),
    COUNTER_MUTATION_RSP(84, Priority.P1, VerbTimeouts.counterTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    COUNTER_MUTATION_REQ(24, Priority.P2, VerbTimeouts.counterTimeout, Stage.COUNTER_MUTATION, () -> CounterMutation.serializer, () -> CounterMutationVerbHandler.instance, COUNTER_MUTATION_RSP),
    READ_RSP(63, Priority.P2, VerbTimeouts.readTimeout, Stage.REQUEST_RESPONSE, () -> ReadResponse.serializer, () -> ResponseVerbHandler.instance),
    READ_REQ(3, Priority.P3, VerbTimeouts.readTimeout, Stage.READ, () -> ReadCommand.serializer, () -> ReadCommandVerbHandler.instance, READ_RSP),
    RANGE_RSP(69, Priority.P2, VerbTimeouts.rangeTimeout, Stage.REQUEST_RESPONSE, () -> ReadResponse.serializer, () -> ResponseVerbHandler.instance),
    RANGE_REQ(9, Priority.P3, VerbTimeouts.rangeTimeout, Stage.READ, () -> ReadCommand.serializer, () -> ReadCommandVerbHandler.instance, RANGE_RSP),
    GOSSIP_DIGEST_SYN(14, Priority.P0, VerbTimeouts.longTimeout, Stage.GOSSIP, () -> GossipDigestSyn.serializer, () -> GossipDigestSynVerbHandler.instance),
    GOSSIP_DIGEST_ACK(15, Priority.P0, VerbTimeouts.longTimeout, Stage.GOSSIP, () -> GossipDigestAck.serializer, () -> GossipDigestAckVerbHandler.instance),
    GOSSIP_DIGEST_ACK2(16, Priority.P0, VerbTimeouts.longTimeout, Stage.GOSSIP, () -> GossipDigestAck2.serializer, () -> GossipDigestAck2VerbHandler.instance),
    GOSSIP_SHUTDOWN(29, Priority.P0, VerbTimeouts.rpcTimeout, Stage.GOSSIP, () -> NoPayload.serializer, () -> GossipShutdownVerbHandler.instance),
    ECHO_RSP(91, Priority.P0, VerbTimeouts.rpcTimeout, Stage.GOSSIP, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    ECHO_REQ(31, Priority.P0, VerbTimeouts.rpcTimeout, Stage.GOSSIP, () -> NoPayload.serializer, () -> EchoVerbHandler.instance, ECHO_RSP),
    PING_RSP(97, Priority.P1, VerbTimeouts.pingTimeout, Stage.GOSSIP, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    PING_REQ(37, Priority.P1, VerbTimeouts.pingTimeout, Stage.GOSSIP, () -> PingRequest.serializer, () -> PingVerbHandler.instance, PING_RSP),
    SCHEMA_PUSH_RSP(98, Priority.P1, VerbTimeouts.rpcTimeout, Stage.MIGRATION, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    SCHEMA_PUSH_REQ(18, Priority.P1, VerbTimeouts.rpcTimeout, Stage.MIGRATION, () -> MigrationManager.MigrationsSerializer.instance, () -> SchemaPushVerbHandler.instance, SCHEMA_PUSH_RSP),
    SCHEMA_PULL_RSP(88, Priority.P1, VerbTimeouts.rpcTimeout, Stage.MIGRATION, () -> MigrationManager.MigrationsSerializer.instance, () -> ResponseVerbHandler.instance),
    SCHEMA_PULL_REQ(28, Priority.P1, VerbTimeouts.rpcTimeout, Stage.MIGRATION, () -> NoPayload.serializer, () -> SchemaPullVerbHandler.instance, SCHEMA_PULL_RSP),
    SCHEMA_VERSION_RSP(80, Priority.P1, VerbTimeouts.rpcTimeout, Stage.MIGRATION, () -> UUIDSerializer.serializer, () -> ResponseVerbHandler.instance),
    SCHEMA_VERSION_REQ(20, Priority.P1, VerbTimeouts.rpcTimeout, Stage.MIGRATION, () -> NoPayload.serializer, () -> SchemaVersionVerbHandler.instance, SCHEMA_VERSION_RSP),
    REPAIR_RSP(100, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.REQUEST_RESPONSE, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    VALIDATION_RSP(102, Priority.P1, VerbTimeouts.longTimeout, Stage.ANTI_ENTROPY, () -> ValidationResponse.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    VALIDATION_REQ(101, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> ValidationRequest.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    SYNC_RSP(104, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> SyncResponse.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    SYNC_REQ(103, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> SyncRequest.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    PREPARE_MSG(105, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> PrepareMessage.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    SNAPSHOT_MSG(106, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> SnapshotMessage.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    CLEANUP_MSG(107, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> CleanupMessage.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    PREPARE_CONSISTENT_RSP(109, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> PrepareConsistentResponse.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    PREPARE_CONSISTENT_REQ(108, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> PrepareConsistentRequest.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    FINALIZE_PROPOSE_MSG(110, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> FinalizePropose.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    FINALIZE_PROMISE_MSG(111, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> FinalizePromise.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    FINALIZE_COMMIT_MSG(112, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> FinalizeCommit.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    FAILED_SESSION_MSG(113, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> FailSession.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    STATUS_RSP(115, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> StatusResponse.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    STATUS_REQ(114, Priority.P1, VerbTimeouts.repairMsgTimeout, Stage.ANTI_ENTROPY, () -> StatusRequest.serializer, () -> RepairMessageVerbHandler.instance, REPAIR_RSP),
    REPLICATION_DONE_RSP(82, Priority.P0, VerbTimeouts.rpcTimeout, Stage.MISC, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    REPLICATION_DONE_REQ(22, Priority.P0, VerbTimeouts.rpcTimeout, Stage.MISC, () -> NoPayload.serializer, () -> ReplicationDoneVerbHandler.instance, REPLICATION_DONE_RSP),
    SNAPSHOT_RSP(87, Priority.P0, VerbTimeouts.rpcTimeout, Stage.MISC, () -> NoPayload.serializer, () -> ResponseVerbHandler.instance),
    SNAPSHOT_REQ(27, Priority.P0, VerbTimeouts.rpcTimeout, Stage.MISC, () -> SnapshotCommand.serializer, () -> SnapshotVerbHandler.instance, SNAPSHOT_RSP),
    FAILURE_RSP(99, Priority.P0, VerbTimeouts.noTimeout, Stage.REQUEST_RESPONSE, () -> RequestFailureReason.serializer, () -> ResponseVerbHandler.instance),
    _TRACE(30, Priority.P1, VerbTimeouts.rpcTimeout, Stage.TRACING, () -> NoPayload.serializer, () -> null),
    _SAMPLE(42, Priority.P1, VerbTimeouts.rpcTimeout, Stage.INTERNAL_RESPONSE, () -> NoPayload.serializer, () -> null),
    _TEST_1(10, Priority.P0, VerbTimeouts.writeTimeout, Stage.IMMEDIATE, () -> NoPayload.serializer, () -> null),
    _TEST_2(11, Priority.P1, VerbTimeouts.rpcTimeout, Stage.IMMEDIATE, () -> NoPayload.serializer, () -> null),
    REQUEST_RSP(4, Priority.P1, VerbTimeouts.rpcTimeout, Stage.REQUEST_RESPONSE, () -> null, () -> ResponseVerbHandler.instance),
    INTERNAL_RSP(23, Priority.P1, VerbTimeouts.rpcTimeout, Stage.INTERNAL_RESPONSE, () -> null, () -> ResponseVerbHandler.instance),
    UNUSED_CUSTOM_VERB(Kind.CUSTOM, 0, Priority.P1, VerbTimeouts.rpcTimeout, Stage.INTERNAL_RESPONSE, () -> null, () -> null);

    public static final List<Verb> VERBS;
    public final int id;
    public final Priority priority;
    public final Stage stage;
    public final Kind kind;
    private final Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> serializer;
    private final Supplier<? extends IVerbHandler<?>> handler;
    final Verb responseVerb;
    private final ToLongFunction<TimeUnit> expiration;
    private static final int CUSTOM_VERB_START = 16383;
    private static final int MAX_CUSTOM_VERB_ID = 1000;
    private static final Verb[] idToVerbMap;
    private static final Verb[] idToCustomVerbMap;
    private static final int minCustomId;

    private Verb(int id, Priority priority, ToLongFunction<TimeUnit> expiration, Stage stage, Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> serializer, Supplier<? extends IVerbHandler<?>> handler) {
        this(id, priority, expiration, stage, serializer, handler, null);
    }

    private Verb(int id, Priority priority, ToLongFunction<TimeUnit> expiration, Stage stage, Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> serializer, Supplier<? extends IVerbHandler<?>> handler, Verb responseVerb) {
        this(Kind.NORMAL, id, priority, expiration, stage, serializer, handler, responseVerb);
    }

    private Verb(Kind kind, int id, Priority priority, ToLongFunction<TimeUnit> expiration, Stage stage, Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> serializer, Supplier<? extends IVerbHandler<?>> handler) {
        this(kind, id, priority, expiration, stage, serializer, handler, null);
    }

    private Verb(Kind kind, int id, Priority priority, ToLongFunction<TimeUnit> expiration, Stage stage, Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> serializer, Supplier<? extends IVerbHandler<?>> handler, Verb responseVerb) {
        this.stage = stage;
        if (id < 0) {
            throw new IllegalArgumentException("Verb id must be non-negative, got " + id + " for verb " + this.name());
        }
        if (kind == Kind.CUSTOM) {
            if (id > 1000) {
                throw new AssertionError((Object)("Invalid custom verb id " + id + " - we only allow custom ids between 0 and " + 1000));
            }
            this.id = Verb.idForCustomVerb(id);
        } else {
            if (id > 15383) {
                throw new AssertionError((Object)("Invalid verb id " + id + " - we only allow ids between 0 and " + 15383));
            }
            this.id = id;
        }
        this.priority = priority;
        this.serializer = serializer;
        this.handler = handler;
        this.responseVerb = responseVerb;
        this.expiration = expiration;
        this.kind = kind;
    }

    public <In, Out> IVersionedAsymmetricSerializer<In, Out> serializer() {
        return this.serializer.get();
    }

    public <T> IVerbHandler<T> handler() {
        return this.handler.get();
    }

    public long expiresAtNanos(long nowNanos) {
        return nowNanos + this.expiresAfterNanos();
    }

    public long expiresAfterNanos() {
        return this.expiration.applyAsLong(TimeUnit.NANOSECONDS);
    }

    public boolean isResponse() {
        return this.handler.get() == ResponseVerbHandler.instance;
    }

    Verb toPre40Verb() {
        if (!this.isResponse()) {
            return this;
        }
        if (this.priority == Priority.P0) {
            return INTERNAL_RSP;
        }
        return REQUEST_RSP;
    }

    @VisibleForTesting
    Supplier<? extends IVerbHandler<?>> unsafeSetHandler(Supplier<? extends IVerbHandler<?>> handler) throws NoSuchFieldException, IllegalAccessException {
        Supplier<? extends IVerbHandler<?>> original = this.handler;
        Field field = Verb.class.getDeclaredField("handler");
        field.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set((Object)this, handler);
        return original;
    }

    @VisibleForTesting
    public Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> unsafeSetSerializer(Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> serializer) throws NoSuchFieldException, IllegalAccessException {
        Supplier<? extends IVersionedAsymmetricSerializer<?, ?>> original = this.serializer;
        Field field = Verb.class.getDeclaredField("serializer");
        field.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set((Object)this, serializer);
        return original;
    }

    @VisibleForTesting
    ToLongFunction<TimeUnit> unsafeSetExpiration(ToLongFunction<TimeUnit> expiration) throws NoSuchFieldException, IllegalAccessException {
        ToLongFunction<TimeUnit> original = this.expiration;
        Field field = Verb.class.getDeclaredField("expiration");
        field.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set((Object)this, expiration);
        return original;
    }

    public static Verb fromId(int id) {
        Verb verb;
        Verb[] verbs = idToVerbMap;
        if (id >= minCustomId) {
            id = Verb.idForCustomVerb(id);
            verbs = idToCustomVerbMap;
        }
        Verb verb2 = verb = id >= 0 && id < verbs.length ? verbs[id] : null;
        if (verb == null) {
            throw new IllegalArgumentException("Unknown verb id " + id);
        }
        return verb;
    }

    private static int idForCustomVerb(int id) {
        return 16383 - id;
    }

    static {
        VERBS = ImmutableList.copyOf((Object[])Verb.values());
        Verb[] verbs = Verb.values();
        int max = -1;
        int minCustom = Integer.MAX_VALUE;
        block8: for (Verb v : verbs) {
            switch (v.kind) {
                case NORMAL: {
                    max = Math.max(v.id, max);
                    continue block8;
                }
                case CUSTOM: {
                    minCustom = Math.min(v.id, minCustom);
                    continue block8;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported Verb Kind: " + (Object)((Object)v.kind) + " for verb " + (Object)((Object)v)));
                }
            }
        }
        minCustomId = minCustom;
        if (minCustom <= max) {
            throw new IllegalStateException("Overlapping verb ids are not allowed");
        }
        Verb[] idMap = new Verb[max + 1];
        int customCount = minCustom < Integer.MAX_VALUE ? 16383 - minCustom : 0;
        Verb[] customIdMap = new Verb[customCount + 1];
        block9: for (Verb v : verbs) {
            switch (v.kind) {
                case NORMAL: {
                    if (idMap[v.id] != null) {
                        throw new IllegalArgumentException("cannot have two verbs that map to the same id: " + (Object)((Object)v) + " and " + (Object)((Object)idMap[v.id]));
                    }
                    idMap[v.id] = v;
                    continue block9;
                }
                case CUSTOM: {
                    int relativeId = Verb.idForCustomVerb(v.id);
                    if (customIdMap[relativeId] != null) {
                        throw new IllegalArgumentException("cannot have two custom verbs that map to the same id: " + (Object)((Object)v) + " and " + (Object)((Object)customIdMap[relativeId]));
                    }
                    customIdMap[relativeId] = v;
                    continue block9;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported Verb Kind: " + (Object)((Object)v.kind) + " for verb " + (Object)((Object)v)));
                }
            }
        }
        idToVerbMap = idMap;
        idToCustomVerbMap = customIdMap;
    }

    public static enum Kind {
        NORMAL,
        CUSTOM;

    }

    public static enum Priority {
        P0,
        P1,
        P2,
        P3,
        P4;

    }
}

