/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.List;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Operations;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.conditions.ColumnCondition;
import org.apache.cassandra.cql3.conditions.Conditions;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(VariableSpecifications bindVariables, TableMetadata cfm, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        super(StatementType.DELETE, bindVariables, cfm, operations, restrictions, conditions, attrs);
    }

    @Override
    public void addUpdateForKey(PartitionUpdate.Builder updateBuilder, Clustering<?> clustering, UpdateParameters params) throws InvalidRequestException {
        TableMetadata metadata = this.metadata();
        List<Operation> regularDeletions = this.getRegularOperations();
        List<Operation> staticDeletions = this.getStaticOperations();
        if (regularDeletions.isEmpty() && staticDeletions.isEmpty()) {
            if (clustering.size() == 0) {
                updateBuilder.addPartitionDeletion(params.deletionTime());
            } else if (clustering.size() == metadata.clusteringColumns().size()) {
                params.newRow(clustering);
                params.addRowDeletion();
                updateBuilder.add(params.buildRow());
            } else {
                updateBuilder.add(params.makeRangeTombstone(metadata.comparator, clustering));
            }
        } else {
            if (!regularDeletions.isEmpty()) {
                RequestValidations.checkFalse(clustering.size() == 0 && metadata.clusteringColumns().size() != 0, "Range deletions are not supported for specific columns");
                params.newRow(clustering);
                for (Operation op : regularDeletions) {
                    op.execute(updateBuilder.partitionKey(), params);
                }
                updateBuilder.add(params.buildRow());
            }
            if (!staticDeletions.isEmpty()) {
                params.newRow(Clustering.STATIC_CLUSTERING);
                for (Operation op : staticDeletions) {
                    op.execute(updateBuilder.partitionKey(), params);
                }
                updateBuilder.add(params.buildRow());
            }
        }
    }

    @Override
    public void addUpdateForKey(PartitionUpdate.Builder update, Slice slice, UpdateParameters params) {
        List<Operation> regularDeletions = this.getRegularOperations();
        List<Operation> staticDeletions = this.getStaticOperations();
        RequestValidations.checkTrue(regularDeletions.isEmpty() && staticDeletions.isEmpty(), "Range deletions are not supported for specific columns");
        update.add(params.makeRangeTombstone(slice));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DELETE, this.keyspace(), this.columnFamily());
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final WhereClause whereClause;

        public Parsed(QualifiedName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, WhereClause whereClause, List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, StatementType.DELETE, attrs, conditions, false, ifExists);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(TableMetadata metadata, VariableSpecifications bindVariables, Conditions conditions, Attributes attrs) {
            RequestValidations.checkFalse(metadata.isVirtual(), "Virtual tables don't support DELETE statements");
            Operations operations = new Operations(this.type);
            for (Operation.RawDeletion deletion : this.deletions) {
                ColumnMetadata def = metadata.getExistingColumn(deletion.affectedColumn());
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", def.name);
                Operation op = deletion.prepare(metadata.keyspace, def, metadata);
                op.collectMarkerSpecification(bindVariables);
                operations.add(op);
            }
            StatementRestrictions restrictions = this.newRestrictions(metadata, bindVariables, operations, this.whereClause, conditions);
            DeleteStatement stmt = new DeleteStatement(bindVariables, metadata, operations, restrictions, conditions, attrs);
            if (stmt.hasConditions() && !restrictions.hasAllPKColumnsRestrictedByEqualities()) {
                RequestValidations.checkFalse(operations.appliesToRegularColumns(), "DELETE statements must restrict all PRIMARY KEY columns with equality relations in order to delete non static columns");
                RequestValidations.checkFalse(conditions.appliesToRegularColumns(), "DELETE statements must restrict all PRIMARY KEY columns with equality relations in order to use IF condition on non static columns");
            }
            return stmt;
        }
    }
}

