/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteLoopExecutor {
    private static final Logger logger = LoggerFactory.getLogger(InfiniteLoopExecutor.class);
    private final Thread thread;
    private final InterruptibleRunnable runnable;
    private volatile boolean isShutdown = false;

    public InfiniteLoopExecutor(String name, InterruptibleRunnable runnable) {
        this.runnable = runnable;
        this.thread = new Thread(this::loop, name);
        this.thread.setDaemon(true);
    }

    private void loop() {
        while (!this.isShutdown) {
            try {
                this.runnable.run();
            }
            catch (InterruptedException ie) {
                if (this.isShutdown) {
                    return;
                }
                logger.error("Interrupted while executing {}, but not shutdown; continuing with loop", (Object)this.runnable, (Object)ie);
            }
            catch (Throwable t) {
                logger.error("Exception thrown by runnable, continuing with loop", t);
            }
        }
    }

    public InfiniteLoopExecutor start() {
        this.thread.start();
        return this;
    }

    public void shutdownNow() {
        this.isShutdown = true;
        this.thread.interrupt();
    }

    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        this.thread.join(unit.toMillis(time));
        return !this.thread.isAlive();
    }

    @VisibleForTesting
    public boolean isAlive() {
        return this.thread.isAlive();
    }

    public static interface InterruptibleRunnable {
        public void run() throws InterruptedException;
    }
}

