/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;

public class MemoryMetadataSerializer<T extends IHopMetadata>
implements IHopMetadataSerializer<T> {
    private final IVariables variables;
    private IHopMetadataProvider metadataProvider;
    private Class<T> managedClass;
    private Map<String, T> objectMap;
    protected String description;

    public MemoryMetadataSerializer(IHopMetadataProvider provider, Class<T> managedClass, IVariables variables, String description) {
        this.metadataProvider = provider;
        this.managedClass = managedClass;
        this.variables = variables;
        this.description = description;
        this.objectMap = new HashMap<String, T>();
    }

    @Override
    public List<T> loadAll() throws HopException {
        ArrayList<T> list = new ArrayList<T>();
        for (String name : this.listObjectNames()) {
            list.add(this.load(name));
        }
        return list;
    }

    @Override
    public T load(String name) throws HopException {
        if (name == null) {
            throw new HopException("Error: you need to specify the name of the metadata object to load");
        }
        if (!this.exists(name)) {
            return null;
        }
        IHopMetadata t = (IHopMetadata)this.objectMap.get(name);
        if (t instanceof IVariables) {
            ((IVariables)((Object)t)).initializeFrom(this.variables);
        }
        t.setMetadataProviderName(this.metadataProvider.getDescription());
        return (T)t;
    }

    @Override
    public void save(T object) throws HopException {
        String name = object.getName();
        this.objectMap.put(name, object);
        object.setMetadataProviderName(this.getMetadataProvider().getDescription());
    }

    @Override
    public T delete(String name) throws HopException {
        if (name == null) {
            throw new HopException("Error: you need to specify the name of the metadata object to delete");
        }
        if (!this.exists(name)) {
            throw new HopException("Error: Object '" + name + "' doesn't exist");
        }
        IHopMetadata t = (IHopMetadata)this.objectMap.get(name);
        this.objectMap.remove(name);
        return (T)t;
    }

    @Override
    public List<String> listObjectNames() throws HopException {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.objectMap.keySet());
        return names;
    }

    @Override
    public boolean exists(String name) throws HopException {
        return this.objectMap.containsKey(name);
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Class<T> getManagedClass() {
        return this.managedClass;
    }

    public void setManagedClass(Class<T> managedClass) {
        this.managedClass = managedClass;
    }

    public Map<String, T> getObjectMap() {
        return this.objectMap;
    }

    public void setObjectMap(Map<String, T> objectMap) {
        this.objectMap = objectMap;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

