/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.Objects;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class Point {
    @HopMetadataProperty(key="xloc")
    public int x;
    @HopMetadataProperty(key="yloc")
    public int y;

    public Point() {
        this(0, 0);
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void multiply(float factor) {
        this.x = Math.round((float)this.x * factor);
        this.y = Math.round((float)this.y * factor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "Point(" + this.x + "," + this.y + ")";
    }

    public DPoint toDouble() {
        return new DPoint(this.x, this.y);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }
}

