/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaData;
import org.apache.hop.pipeline.transforms.formula.FormulaMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaMetaFunction;
import org.apache.hop.pipeline.transforms.formula.util.FormulaParser;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Formula
extends BaseTransform<FormulaMeta, FormulaData> {
    private XSSFWorkbook workBook;
    private XSSFSheet workSheet;
    private Row sheetRow;

    public boolean init() {
        this.workBook = new XSSFWorkbook();
        this.workSheet = this.workBook.createSheet();
        this.sheetRow = this.workSheet.createRow(0);
        ((FormulaData)this.data).returnType = new int[((FormulaMeta)this.meta).getFormulas().size()];
        for (int i = 0; i < ((FormulaMeta)this.meta).getFormulas().size(); ++i) {
            ((FormulaData)this.data).returnType[i] = -1;
        }
        return true;
    }

    public void dispose() {
        try {
            this.workBook.close();
        }
        catch (IOException e) {
            this.logError("Unable to close temporary workbook", e);
        }
        super.dispose();
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        int tempIndex = this.getInputRowMeta().size();
        if (this.first) {
            this.first = false;
            ((FormulaData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((FormulaMeta)this.meta).getFields(((FormulaData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((FormulaData)this.data).replaceIndex = new int[((FormulaMeta)this.meta).getFormulas().size()];
            for (int i = 0; i < ((FormulaMeta)this.meta).getFormulas().size(); ++i) {
                FormulaMetaFunction fn = ((FormulaMeta)this.meta).getFormulas().get(i);
                if (!Utils.isEmpty((CharSequence)fn.getReplaceField())) {
                    ((FormulaData)this.data).replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (((FormulaData)this.data).replaceIndex[i] >= 0) continue;
                    throw new HopException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                ((FormulaData)this.data).replaceIndex[i] = -1;
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + Arrays.toString(r));
        }
        if (this.sheetRow != null) {
            this.workSheet.removeRow(this.sheetRow);
        }
        this.sheetRow = this.workSheet.createRow(0);
        Object outputValue = null;
        Object[] outputRowData = RowDataUtil.resizeArray((Object[])r, (int)((FormulaData)this.data).outputRowMeta.size());
        for (int i = 0; i < ((FormulaMeta)this.meta).getFormulas().size(); ++i) {
            FormulaMetaFunction formula = ((FormulaMeta)this.meta).getFormulas().get(i);
            FormulaParser parser = new FormulaParser(formula, this.getInputRowMeta(), r, this.sheetRow, this.variables);
            CellValue cellValue = parser.getFormulaValue();
            CellType cellType = cellValue.getCellType();
            block0 : switch (cellType) {
                case BLANK: {
                    break;
                }
                case NUMERIC: {
                    outputValue = cellValue.getNumberValue();
                    int outputValueType = formula.getValueType();
                    switch (outputValueType) {
                        case 1: {
                            ((FormulaData)this.data).returnType[i] = 1;
                            formula.setNeedDataConversion(formula.getValueType() != 1);
                            break block0;
                        }
                        case 5: {
                            ((FormulaData)this.data).returnType[i] = 2;
                            formula.setNeedDataConversion(formula.getValueType() != 1);
                            break block0;
                        }
                        case 6: {
                            ((FormulaData)this.data).returnType[i] = 5;
                            formula.setNeedDataConversion(formula.getValueType() != 1);
                            break block0;
                        }
                        case 3: {
                            outputValue = DateUtil.getJavaDate((double)cellValue.getNumberValue());
                            ((FormulaData)this.data).returnType[i] = 4;
                            formula.setNeedDataConversion(formula.getValueType() != 1);
                            break block0;
                        }
                        case 9: {
                            outputValue = Timestamp.from(DateUtil.getJavaDate((double)cellValue.getNumberValue()).toInstant());
                            ((FormulaData)this.data).returnType[i] = 9;
                            formula.setNeedDataConversion(formula.getValueType() != 1);
                            break block0;
                        }
                    }
                    break;
                }
                case BOOLEAN: {
                    outputValue = cellValue.getBooleanValue();
                    ((FormulaData)this.data).returnType[i] = 7;
                    formula.setNeedDataConversion(formula.getValueType() != 4);
                    break;
                }
                case STRING: {
                    outputValue = cellValue.getStringValue();
                    ((FormulaData)this.data).returnType[i] = 0;
                    formula.setNeedDataConversion(formula.getValueType() != 2);
                    break;
                }
            }
            int realIndex = ((FormulaData)this.data).replaceIndex[i] < 0 ? tempIndex++ : ((FormulaData)this.data).replaceIndex[i];
            outputRowData[realIndex] = this.getReturnValue(outputValue, ((FormulaData)this.data).returnType[i], realIndex, formula);
        }
        this.putRow(((FormulaData)this.data).outputRowMeta, outputRowData);
        if (this.log.isRowLevel()) {
            this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + Arrays.toString(r));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public Formula(TransformMeta transformMeta, FormulaMeta meta, FormulaData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected Object getReturnValue(Object formulaResult, int returnType, int realIndex, FormulaMetaFunction fn) throws HopException {
        if (formulaResult == null) {
            return null;
        }
        Object value = null;
        switch (returnType) {
            case 0: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult.toString();
                break;
            }
            case 1: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = ((Number)formulaResult).doubleValue();
                break;
            }
            case 2: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 3: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 4: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 5: {
                if (fn.isNeedDataConversion()) {
                    value = this.convertDataToTargetValueMeta(realIndex, formulaResult);
                    break;
                }
                value = formulaResult;
                break;
            }
            case 6: {
                value = formulaResult;
                break;
            }
            case 7: {
                value = formulaResult;
                break;
            }
            case 9: {
                value = fn.isNeedDataConversion() ? this.convertDataToTargetValueMeta(realIndex, formulaResult) : formulaResult;
            }
        }
        return value;
    }

    private Object convertDataToTargetValueMeta(int i, Object formulaResult) throws HopException {
        if (formulaResult == null) {
            return formulaResult;
        }
        IValueMeta target = ((FormulaData)this.data).outputRowMeta.getValueMeta(i);
        IValueMeta actual = ValueMetaFactory.guessValueMetaInterface((Object)formulaResult);
        return target.convertData(actual, formulaResult);
    }
}

