/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2ReadResponse;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class HL7v2ReadResponseCoder
extends CustomCoder<HL7v2ReadResponse> {
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized HL7v2MessageCoder HL7V2_MESSAGE_CODER = HL7v2MessageCoder.of();

    HL7v2ReadResponseCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized HL7v2ReadResponseCoder of() {
        return new HL7v2ReadResponseCoder();
    }

    public static @UnknownKeyFor @NonNull @Initialized HL7v2ReadResponseCoder of(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized HL7v2ReadResponse> clazz) {
        return new HL7v2ReadResponseCoder();
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized HL7v2ReadResponse value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        STRING_CODER.encode((Object)value.getMetadata(), outStream);
        HL7V2_MESSAGE_CODER.encode(value.getHL7v2Message(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized HL7v2ReadResponse decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        String metadata = (String)STRING_CODER.decode(inStream);
        HL7v2Message message = HL7V2_MESSAGE_CODER.decode(inStream);
        return HL7v2ReadResponse.of(metadata, message);
    }
}

