/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.id;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.util.HashSet;
import java.util.Set;

public abstract class IdElement
implements Element {
    protected final Element baseElement;
    protected final IdGraph idGraph;
    protected final boolean propertyBased;

    protected IdElement(Element baseElement, IdGraph idGraph, boolean propertyBased) {
        this.baseElement = baseElement;
        this.idGraph = idGraph;
        this.propertyBased = propertyBased;
    }

    @Override
    public <T> T getProperty(String key) {
        if (this.propertyBased && key.equals("__id")) {
            return null;
        }
        return this.baseElement.getProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        if (this.propertyBased) {
            Set<String> keys = this.baseElement.getPropertyKeys();
            HashSet<String> s = new HashSet<String>();
            s.addAll(keys);
            s.remove("__id");
            return s;
        }
        return this.baseElement.getPropertyKeys();
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.propertyBased && key.equals("__id")) {
            throw new IllegalArgumentException("Unable to set value for reserved property __id");
        }
        this.baseElement.setProperty(key, value);
    }

    @Override
    public <T> T removeProperty(String key) {
        if (this.propertyBased && key.equals("__id")) {
            throw new IllegalArgumentException("Unable to remove value for reserved property __id");
        }
        return this.baseElement.removeProperty(key);
    }

    @Override
    public Object getId() {
        return this.propertyBased ? this.baseElement.getProperty("__id") : this.baseElement.getId();
    }

    public int hashCode() {
        return this.baseElement.hashCode();
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    @Override
    public void remove() {
        if (this instanceof Vertex) {
            this.idGraph.removeVertex((Vertex)((Object)this));
        } else {
            this.idGraph.removeEdge((Edge)((Object)this));
        }
    }
}

