/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.util.TransactionRetryStrategy;
import com.tinkerpop.blueprints.util.TransactionWork;
import java.util.Set;

public class TransactionRetryHelper<T> {
    private final TransactionalGraph graph;
    private final TransactionWork<T> work;

    private TransactionRetryHelper(Builder<T> builder) {
        this.graph = builder.getGraph();
        this.work = builder.getWork();
    }

    public T fireAndForget() {
        return this.use(new TransactionRetryStrategy.FireAndForget());
    }

    public T oneAndDone() {
        return this.use(new TransactionRetryStrategy.OneAndDone());
    }

    public T retry() {
        return this.use(new TransactionRetryStrategy.DelayedRetry());
    }

    public T retry(int retries) {
        return this.use(new TransactionRetryStrategy.DelayedRetry(retries, 20L));
    }

    public T retry(int retries, long delayBetweenRetries) {
        return this.use(new TransactionRetryStrategy.DelayedRetry(retries, delayBetweenRetries));
    }

    public T retry(int retries, long delayBetweenRetries, Set<Class> exceptionsToRetryOn) {
        return this.use(new TransactionRetryStrategy.DelayedRetry(retries, delayBetweenRetries, exceptionsToRetryOn));
    }

    public T exponentialBackoff() {
        return this.use(new TransactionRetryStrategy.ExponentialBackoff());
    }

    public T exponentialBackoff(int retries) {
        return this.use(new TransactionRetryStrategy.ExponentialBackoff(retries, 20L));
    }

    public T exponentialBackoff(int retries, long initialDelay) {
        return this.use(new TransactionRetryStrategy.ExponentialBackoff(retries, initialDelay));
    }

    public T exponentialBackoff(int retries, long initialDelay, Set<Class> exceptionsToRetryOn) {
        return this.use(new TransactionRetryStrategy.ExponentialBackoff(retries, initialDelay, exceptionsToRetryOn));
    }

    public T use(TransactionRetryStrategy<T> strategy) {
        return strategy.execute(this.graph, this.work);
    }

    public static class Builder<T> {
        private final TransactionalGraph graph;
        private TransactionWork<T> work;

        public Builder(TransactionalGraph graph) {
            this.graph = graph;
        }

        public Builder<T> perform(TransactionWork<T> work) {
            this.work = work;
            return this;
        }

        public TransactionRetryHelper<T> build() {
            return new TransactionRetryHelper(this);
        }

        public TransactionalGraph getGraph() {
            return this.graph;
        }

        public TransactionWork<T> getWork() {
            return this.work;
        }
    }
}

