/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.denormaliser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserData;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserMeta;
import org.apache.hop.pipeline.transforms.denormaliser.DenormaliserTargetField;

public class Denormaliser
extends BaseTransform<DenormaliserMeta, DenormaliserData> {
    private static final Class<?> PKG = DenormaliserMeta.class;
    private boolean allNullsAreZero = false;
    private boolean minNullIsValued = false;
    private Map<String, IValueMeta> conversionMetaCache = new HashMap<String, IValueMeta>();

    public Denormaliser(TransformMeta transformMeta, DenormaliserMeta meta, DenormaliserData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.handleLastRow();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (!this.processFirstRow()) {
                return false;
            }
            this.newGroup();
            this.deNormalise(((DenormaliserData)this.data).inputRowMeta, r);
            ((DenormaliserData)this.data).previous = r;
            this.first = false;
            return true;
        }
        if (!this.sameGroup(((DenormaliserData)this.data).inputRowMeta, ((DenormaliserData)this.data).previous, r)) {
            Object[] outputRowData = this.buildResult(((DenormaliserData)this.data).inputRowMeta, ((DenormaliserData)this.data).previous);
            this.putRow(((DenormaliserData)this.data).outputRowMeta, outputRowData);
            this.newGroup();
            this.deNormalise(((DenormaliserData)this.data).inputRowMeta, r);
        } else {
            this.deNormalise(((DenormaliserData)this.data).inputRowMeta, r);
        }
        ((DenormaliserData)this.data).previous = r;
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Denormaliser.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private boolean processFirstRow() throws HopTransformException {
        int i;
        this.allNullsAreZero = this.getVariableBoolean("HOP_AGGREGATION_ALL_NULLS_ARE_ZERO", false);
        this.minNullIsValued = this.getVariableBoolean("HOP_AGGREGATION_MIN_NULL_IS_VALUED", false);
        ((DenormaliserData)this.data).inputRowMeta = this.getInputRowMeta();
        ((DenormaliserData)this.data).outputRowMeta = ((DenormaliserData)this.data).inputRowMeta.clone();
        ((DenormaliserMeta)this.meta).getFields(((DenormaliserData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        ((DenormaliserData)this.data).keyFieldNr = ((DenormaliserData)this.data).inputRowMeta.indexOfValue(((DenormaliserMeta)this.meta).getKeyField());
        if (((DenormaliserData)this.data).keyFieldNr < 0) {
            this.logError(BaseMessages.getString(PKG, (String)"Denormaliser.Log.KeyFieldNotFound", (String[])new String[]{((DenormaliserMeta)this.meta).getKeyField()}));
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        Hashtable<Integer, Integer> subjects = new Hashtable<Integer, Integer>();
        ((DenormaliserData)this.data).fieldNameIndex = new int[((DenormaliserMeta)this.meta).getDenormaliserTargetFields().size()];
        for (int i2 = 0; i2 < ((DenormaliserMeta)this.meta).getDenormaliserTargetFields().size(); ++i2) {
            DenormaliserTargetField field = ((DenormaliserMeta)this.meta).getDenormaliserTargetFields().get(i2);
            int idx = ((DenormaliserData)this.data).inputRowMeta.indexOfValue(field.getFieldName());
            if (idx < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Denormaliser.Log.UnpivotFieldNotFound", (String[])new String[]{field.getFieldName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ((DenormaliserData)this.data).fieldNameIndex[i2] = idx;
            subjects.put(idx, idx);
            if (((DenormaliserData)this.data).fieldNameIndex[i2] == ((DenormaliserData)this.data).keyFieldNr) {
                this.logError(BaseMessages.getString(PKG, (String)"Denormaliser.Log.ValueFieldSameAsKeyField", (String[])new String[]{field.getFieldName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            String keyValue = this.resolve(field.getKeyValue());
            List<Integer> indexes = ((DenormaliserData)this.data).keyValue.get(keyValue);
            if (indexes == null) {
                indexes = new ArrayList<Integer>(2);
            }
            indexes.add(i2);
            ((DenormaliserData)this.data).keyValue.put(keyValue, indexes);
        }
        Set subjectSet = subjects.keySet();
        ((DenormaliserData)this.data).fieldNrs = subjectSet.toArray(new Integer[subjectSet.size()]);
        ((DenormaliserData)this.data).groupnrs = new int[((DenormaliserMeta)this.meta).getGroupFields().size()];
        for (int i3 = 0; i3 < ((DenormaliserMeta)this.meta).getGroupFields().size(); ++i3) {
            ((DenormaliserData)this.data).groupnrs[i3] = ((DenormaliserData)this.data).inputRowMeta.indexOfValue(((DenormaliserMeta)this.meta).getGroupFields().get(i3).getName());
            if (((DenormaliserData)this.data).groupnrs[i3] >= 0) continue;
            this.logError(BaseMessages.getString(PKG, (String)"Denormaliser.Log.GroupingFieldNotFound", (Object[])new Object[]{((DenormaliserMeta)this.meta).getGroupFields().get(i3)}));
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        removeList.add(((DenormaliserData)this.data).keyFieldNr);
        for (i = 0; i < ((DenormaliserData)this.data).fieldNrs.length; ++i) {
            removeList.add(((DenormaliserData)this.data).fieldNrs[i]);
        }
        Collections.sort(removeList);
        ((DenormaliserData)this.data).removeNrs = new int[removeList.size()];
        for (i = 0; i < removeList.size(); ++i) {
            ((DenormaliserData)this.data).removeNrs[i] = (Integer)removeList.get(i);
        }
        return true;
    }

    private void handleLastRow() throws HopException {
        if (((DenormaliserData)this.data).previous != null) {
            Object[] outputRowData = this.buildResult(((DenormaliserData)this.data).inputRowMeta, ((DenormaliserData)this.data).previous);
            this.putRow(((DenormaliserData)this.data).outputRowMeta, outputRowData);
        }
    }

    Object[] buildResult(IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        int i;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)((DenormaliserData)this.data).outputRowMeta.size());
        int outputIndex = 0;
        int removeIndex = 0;
        for (i = 0; i < rowMeta.size(); ++i) {
            if (removeIndex < ((DenormaliserData)this.data).removeNrs.length && i == ((DenormaliserData)this.data).removeNrs[removeIndex]) {
                ++removeIndex;
                continue;
            }
            outputRowData[outputIndex++] = rowData[i];
        }
        for (i = 0; i < ((DenormaliserData)this.data).targetResult.length; ++i) {
            Object resultValue = ((DenormaliserData)this.data).targetResult[i];
            DenormaliserTargetField field = ((DenormaliserMeta)this.meta).getDenormaliserTargetFields().get(i);
            switch (field.getTargetAggregationType()) {
                case TYPE_AGGR_AVERAGE: {
                    long count = ((DenormaliserData)this.data).counters[i];
                    Object sum = ((DenormaliserData)this.data).sum[i];
                    if (count <= 0L) break;
                    if (sum instanceof Long) {
                        resultValue = (Long)sum / count;
                        break;
                    }
                    if (sum instanceof Double) {
                        resultValue = (Double)sum / (double)count;
                        break;
                    }
                    if (sum instanceof BigDecimal) {
                        resultValue = ((BigDecimal)sum).divide(new BigDecimal(count));
                        break;
                    }
                    resultValue = null;
                    break;
                }
                case TYPE_AGGR_COUNT_ALL: {
                    if (resultValue == null) {
                        resultValue = 0L;
                    }
                    if (field.getTargetType().equals(ValueMetaFactory.getValueMetaName((int)5))) break;
                    resultValue = ((DenormaliserData)this.data).outputRowMeta.getValueMeta(outputIndex).convertData((IValueMeta)new ValueMetaInteger("num_values_aggregation"), resultValue);
                    break;
                }
            }
            if (resultValue == null && this.allNullsAreZero) {
                resultValue = this.getZero(outputIndex);
            }
            outputRowData[outputIndex++] = resultValue;
        }
        return outputRowData;
    }

    private Object getZero(int field) throws HopValueException {
        IValueMeta vm = ((DenormaliserData)this.data).outputRowMeta.getValueMeta(field);
        return ValueDataUtil.getZeroForValueMetaType((IValueMeta)vm);
    }

    private boolean sameGroup(IRowMeta rowMeta, Object[] previous, Object[] rowData) throws HopValueException {
        return rowMeta.compare(previous, rowData, ((DenormaliserData)this.data).groupnrs) == 0;
    }

    private void newGroup() throws HopException {
        ((DenormaliserData)this.data).targetResult = new Object[((DenormaliserMeta)this.meta).getDenormaliserTargetFields().size()];
        List<DenormaliserTargetField> fields = ((DenormaliserMeta)this.meta).getDenormaliserTargetFields();
        for (int i = 0; i < fields.size(); ++i) {
            ((DenormaliserData)this.data).counters[i] = 0L;
            ((DenormaliserData)this.data).sum[i] = null;
        }
    }

    void deNormalise(IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        Object valueData;
        IValueMeta valueMeta = rowMeta.getValueMeta(((DenormaliserData)this.data).keyFieldNr);
        String key = valueMeta.getCompatibleString(valueData = rowData[((DenormaliserData)this.data).keyFieldNr]);
        if (Utils.isEmpty((CharSequence)key)) {
            return;
        }
        List<Integer> indexes = ((DenormaliserData)this.data).keyValue.get(key);
        if (indexes == null) {
            return;
        }
        for (Integer keyNr : indexes) {
            if (keyNr == null) continue;
            int idx = keyNr;
            DenormaliserTargetField field = ((DenormaliserMeta)this.meta).getDenormaliserTargetFields().get(idx);
            IValueMeta sourceMeta = rowMeta.getValueMeta(((DenormaliserData)this.data).fieldNameIndex[idx]);
            Object sourceData = rowData[((DenormaliserData)this.data).fieldNameIndex[idx]];
            IValueMeta targetMeta = ((DenormaliserData)this.data).outputRowMeta.getValueMeta(((DenormaliserData)this.data).inputRowMeta.size() - ((DenormaliserData)this.data).removeNrs.length + idx);
            Object prevTargetData = ((DenormaliserData)this.data).targetResult[idx];
            IValueMeta origSourceMeta = sourceMeta;
            if (targetMeta.isDate()) {
                sourceMeta = origSourceMeta.clone();
                sourceMeta.setConversionMetadata(this.getConversionMeta(field.getTargetFormat()));
            }
            switch (field.getTargetAggregationType()) {
                case TYPE_AGGR_SUM: {
                    Object targetData = targetMeta.convertData(sourceMeta, sourceData);
                    if (prevTargetData != null) {
                        prevTargetData = ValueDataUtil.sum((IValueMeta)targetMeta, (Object)prevTargetData, (IValueMeta)targetMeta, (Object)targetData);
                        break;
                    }
                    prevTargetData = targetData;
                    break;
                }
                case TYPE_AGGR_MIN: {
                    if (sourceData == null && !this.minNullIsValued || (prevTargetData != null || this.minNullIsValued) && sourceMeta.compare(sourceData, targetMeta, prevTargetData) >= 0) break;
                    prevTargetData = targetMeta.convertData(sourceMeta, sourceData);
                    break;
                }
                case TYPE_AGGR_MAX: {
                    if (sourceMeta.compare(sourceData, targetMeta, prevTargetData) <= 0) break;
                    prevTargetData = targetMeta.convertData(sourceMeta, sourceData);
                    break;
                }
                case TYPE_AGGR_COUNT_ALL: {
                    int n = idx;
                    long l = ((DenormaliserData)this.data).counters[n] + 1L;
                    ((DenormaliserData)this.data).counters[n] = l;
                    prevTargetData = l;
                    break;
                }
                case TYPE_AGGR_AVERAGE: {
                    Object targetData = targetMeta.convertData(sourceMeta, sourceData);
                    if (sourceMeta.isNull(sourceData)) break;
                    int n = idx;
                    long l = ((DenormaliserData)this.data).counters[n];
                    ((DenormaliserData)this.data).counters[n] = l + 1L;
                    prevTargetData = l;
                    if (((DenormaliserData)this.data).sum[idx] == null) {
                        ((DenormaliserData)this.data).sum[idx] = targetData;
                        break;
                    }
                    ((DenormaliserData)this.data).sum[idx] = ValueDataUtil.plus((IValueMeta)targetMeta, (Object)((DenormaliserData)this.data).sum[idx], (IValueMeta)targetMeta, (Object)targetData);
                    break;
                }
                case TYPE_AGGR_CONCAT_COMMA: {
                    String separator = ",";
                    Object targetData = targetMeta.convertData(sourceMeta, sourceData);
                    if (prevTargetData != null) {
                        prevTargetData = prevTargetData + separator + targetData;
                        break;
                    }
                    prevTargetData = targetData;
                    break;
                }
                default: {
                    prevTargetData = targetMeta.convertData(sourceMeta, sourceData);
                }
            }
            ((DenormaliserData)this.data).targetResult[idx] = prevTargetData;
        }
    }

    public boolean init() {
        if (super.init()) {
            ((DenormaliserData)this.data).counters = new long[((DenormaliserMeta)this.meta).getDenormaliserTargetFields().size()];
            ((DenormaliserData)this.data).sum = new Object[((DenormaliserMeta)this.meta).getDenormaliserTargetFields().size()];
            return true;
        }
        return false;
    }

    public void batchComplete() throws HopException {
        this.handleLastRow();
        ((DenormaliserData)this.data).previous = null;
        this.first = true;
    }

    private IValueMeta getConversionMeta(String mask) {
        IValueMeta meta = null;
        if (!Utils.isEmpty((CharSequence)mask) && (meta = this.conversionMetaCache.get(mask)) == null) {
            meta = new ValueMetaDate();
            meta.setConversionMask(mask);
            this.conversionMetaCache.put(mask, meta);
        }
        return meta;
    }

    void setAllNullsAreZero(boolean allNullsAreZero) {
        this.allNullsAreZero = allNullsAreZero;
    }

    void setMinNullIsValued(boolean minNullIsValued) {
        this.minNullIsValued = minNullIsValued;
    }
}

