/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.stub.HttpJsonSpannerCallableFactory;
import com.google.cloud.spanner.v1.stub.SpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSpannerStub
extends SpannerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateSessionRequest, Session> createSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/CreateSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/instances/*/databases/*}/sessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", (Object)request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/BatchCreateSessions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/instances/*/databases/*}/sessions:batchCreate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", (Object)request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearDatabase().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchCreateSessionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSessionRequest, Session> getSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/GetSession").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/instances/*/databases/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSessionsRequest, ListSessionsResponse> listSessionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/ListSessions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database=projects/*/instances/*/databases/*}/sessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database", (Object)request.getDatabase());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSessionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSessionRequest, Empty> deleteSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/DeleteSession").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/instances/*/databases/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExecuteSqlRequest, ResultSet> executeSqlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/ExecuteSql").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:executeSql", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResultSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/ExecuteStreamingSql").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:executeStreamingSql", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PartialResultSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/ExecuteBatchDml").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:executeBatchDml", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ExecuteBatchDmlResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ReadRequest, ResultSet> readMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/Read").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:read", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ResultSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ReadRequest, PartialResultSet> streamingReadMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/StreamingRead").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:streamingRead", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PartialResultSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BeginTransactionRequest, Transaction> beginTransactionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/BeginTransaction").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:beginTransaction", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Transaction.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/Commit").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:commit", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CommitResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RollbackRequest, Empty> rollbackMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/Rollback").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:rollback", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PartitionQueryRequest, PartitionResponse> partitionQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/PartitionQuery").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:partitionQuery", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PartitionResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PartitionReadRequest, PartitionResponse> partitionReadMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.v1.Spanner/PartitionRead").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{session=projects/*/instances/*/databases/*/sessions/*}:partitionRead", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "session", (Object)request.getSession());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSession().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PartitionResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSessionRequest, Session> createSessionCallable;
    private final UnaryCallable<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsCallable;
    private final UnaryCallable<GetSessionRequest, Session> getSessionCallable;
    private final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable;
    private final UnaryCallable<ListSessionsRequest, SpannerClient.ListSessionsPagedResponse> listSessionsPagedCallable;
    private final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable;
    private final UnaryCallable<ExecuteSqlRequest, ResultSet> executeSqlCallable;
    private final ServerStreamingCallable<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlCallable;
    private final UnaryCallable<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlCallable;
    private final UnaryCallable<ReadRequest, ResultSet> readCallable;
    private final ServerStreamingCallable<ReadRequest, PartialResultSet> streamingReadCallable;
    private final UnaryCallable<BeginTransactionRequest, Transaction> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, Empty> rollbackCallable;
    private final UnaryCallable<PartitionQueryRequest, PartitionResponse> partitionQueryCallable;
    private final UnaryCallable<PartitionReadRequest, PartitionResponse> partitionReadCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSpannerStub create(SpannerStubSettings settings) throws IOException {
        return new HttpJsonSpannerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSpannerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSpannerStub(SpannerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSpannerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSpannerStub(SpannerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSpannerStub(SpannerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSpannerCallableFactory());
    }

    protected HttpJsonSpannerStub(SpannerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchCreateSessionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchCreateSessionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSessionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listSessionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSessionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSessionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings executeSqlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(executeSqlMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings executeStreamingSqlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(executeStreamingSqlMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings executeBatchDmlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(executeBatchDmlMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings readTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(readMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings streamingReadTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(streamingReadMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings beginTransactionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings commitTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings rollbackTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings partitionQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(partitionQueryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings partitionReadTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(partitionReadMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.batchCreateSessionsCallable = callableFactory.createUnaryCallable(batchCreateSessionsTransportSettings, settings.batchCreateSessionsSettings(), clientContext);
        this.getSessionCallable = callableFactory.createUnaryCallable(getSessionTransportSettings, settings.getSessionSettings(), clientContext);
        this.listSessionsCallable = callableFactory.createUnaryCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listSessionsPagedCallable = callableFactory.createPagedCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.deleteSessionCallable = callableFactory.createUnaryCallable(deleteSessionTransportSettings, settings.deleteSessionSettings(), clientContext);
        this.executeSqlCallable = callableFactory.createUnaryCallable(executeSqlTransportSettings, settings.executeSqlSettings(), clientContext);
        this.executeStreamingSqlCallable = callableFactory.createServerStreamingCallable(executeStreamingSqlTransportSettings, settings.executeStreamingSqlSettings(), clientContext);
        this.executeBatchDmlCallable = callableFactory.createUnaryCallable(executeBatchDmlTransportSettings, settings.executeBatchDmlSettings(), clientContext);
        this.readCallable = callableFactory.createUnaryCallable(readTransportSettings, settings.readSettings(), clientContext);
        this.streamingReadCallable = callableFactory.createServerStreamingCallable(streamingReadTransportSettings, settings.streamingReadSettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.partitionQueryCallable = callableFactory.createUnaryCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.partitionReadCallable = callableFactory.createUnaryCallable(partitionReadTransportSettings, settings.partitionReadSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSessionMethodDescriptor);
        methodDescriptors.add(batchCreateSessionsMethodDescriptor);
        methodDescriptors.add(getSessionMethodDescriptor);
        methodDescriptors.add(listSessionsMethodDescriptor);
        methodDescriptors.add(deleteSessionMethodDescriptor);
        methodDescriptors.add(executeSqlMethodDescriptor);
        methodDescriptors.add(executeStreamingSqlMethodDescriptor);
        methodDescriptors.add(executeBatchDmlMethodDescriptor);
        methodDescriptors.add(readMethodDescriptor);
        methodDescriptors.add(streamingReadMethodDescriptor);
        methodDescriptors.add(beginTransactionMethodDescriptor);
        methodDescriptors.add(commitMethodDescriptor);
        methodDescriptors.add(rollbackMethodDescriptor);
        methodDescriptors.add(partitionQueryMethodDescriptor);
        methodDescriptors.add(partitionReadMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public UnaryCallable<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsCallable() {
        return this.batchCreateSessionsCallable;
    }

    @Override
    public UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.getSessionCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.listSessionsCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, SpannerClient.ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.listSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.deleteSessionCallable;
    }

    @Override
    public UnaryCallable<ExecuteSqlRequest, ResultSet> executeSqlCallable() {
        return this.executeSqlCallable;
    }

    @Override
    public ServerStreamingCallable<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlCallable() {
        return this.executeStreamingSqlCallable;
    }

    @Override
    public UnaryCallable<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlCallable() {
        return this.executeBatchDmlCallable;
    }

    @Override
    public UnaryCallable<ReadRequest, ResultSet> readCallable() {
        return this.readCallable;
    }

    @Override
    public ServerStreamingCallable<ReadRequest, PartialResultSet> streamingReadCallable() {
        return this.streamingReadCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, Transaction> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, PartitionResponse> partitionQueryCallable() {
        return this.partitionQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionReadRequest, PartitionResponse> partitionReadCallable() {
        return this.partitionReadCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

