/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ClientSideStatement;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.PostgreSQLStatementParser;
import com.google.cloud.spanner.connection.SpannerStatementParser;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@InternalApi
public abstract class AbstractStatementParser {
    private static final Object lock = new Object();
    private static final Map<Dialect, AbstractStatementParser> INSTANCES = new HashMap<Dialect, AbstractStatementParser>();
    private static final ImmutableMap<Dialect, Class<? extends AbstractStatementParser>> KNOWN_PARSER_CLASSES = ImmutableMap.of((Object)((Object)Dialect.GOOGLE_STANDARD_SQL), SpannerStatementParser.class, (Object)((Object)Dialect.POSTGRESQL), PostgreSQLStatementParser.class);
    static final ParsedStatement BEGIN_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("BEGIN"));
    static final ParsedStatement COMMIT_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("COMMIT"));
    static final ParsedStatement ROLLBACK_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("ROLLBACK"));
    static final ParsedStatement RUN_BATCH_STATEMENT = AbstractStatementParser.getInstance(Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of("RUN BATCH"));
    static final Set<String> ddlStatements = ImmutableSet.of((Object)"CREATE", (Object)"DROP", (Object)"ALTER", (Object)"ANALYZE", (Object)"GRANT", (Object)"REVOKE", (Object[])new String[0]);
    static final Set<String> selectStatements = ImmutableSet.of((Object)"SELECT", (Object)"WITH", (Object)"SHOW");
    static final Set<String> dmlStatements = ImmutableSet.of((Object)"INSERT", (Object)"UPDATE", (Object)"DELETE");
    private final Set<ClientSideStatementImpl> statements;
    static final char SINGLE_QUOTE = '\'';
    static final char DOUBLE_QUOTE = '\"';
    static final char BACKTICK_QUOTE = '`';
    static final char HYPHEN = '-';
    static final char DASH = '#';
    static final char SLASH = '/';
    static final char ASTERISK = '*';
    static final char DOLLAR = '$';
    static final char SPACE = ' ';
    static final char CLOSE_PARENTHESIS = ')';
    static final char COMMA = ',';
    static final char UNDERSCORE = '_';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractStatementParser getInstance(Dialect dialect) {
        Object object = lock;
        synchronized (object) {
            if (!INSTANCES.containsKey((Object)dialect)) {
                try {
                    Class clazz = (Class)KNOWN_PARSER_CLASSES.get((Object)dialect);
                    if (clazz == null) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "There is no known statement parser for dialect " + (Object)((Object)dialect));
                    }
                    INSTANCES.put(dialect, (AbstractStatementParser)clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Could not instantiate statement parser for dialect " + dialect.name(), e);
                }
            }
            return INSTANCES.get((Object)dialect);
        }
    }

    AbstractStatementParser(Set<ClientSideStatementImpl> statements) {
        this.statements = Collections.unmodifiableSet(statements);
    }

    @VisibleForTesting
    Set<ClientSideStatementImpl> getClientSideStatements() {
        return this.statements;
    }

    @InternalApi
    public ParsedStatement parse(Statement statement) {
        return this.parse(statement, null);
    }

    ParsedStatement parse(Statement statement, ExecuteSqlRequest.QueryOptions defaultQueryOptions) {
        String sql = this.removeCommentsAndTrim(statement.getSql());
        ClientSideStatementImpl client = this.parseClientSideStatement(sql);
        if (client != null) {
            return ParsedStatement.clientSideStatement(client, statement, sql);
        }
        if (this.isQuery(sql)) {
            return ParsedStatement.query(statement, sql, defaultQueryOptions);
        }
        if (this.isUpdateStatement(sql)) {
            return ParsedStatement.update(statement, sql, this.checkReturningClause(sql));
        }
        if (this.isDdlStatement(sql)) {
            return ParsedStatement.ddl(statement, sql);
        }
        return ParsedStatement.unknown(statement, sql);
    }

    @VisibleForTesting
    ClientSideStatementImpl parseClientSideStatement(String sql) {
        for (ClientSideStatementImpl css : this.statements) {
            if (!css.matches(sql)) continue;
            return css;
        }
        return null;
    }

    @InternalApi
    public boolean isDdlStatement(String sql) {
        return this.statementStartsWith(sql, ddlStatements);
    }

    @InternalApi
    public boolean isQuery(String sql) {
        if (sql.startsWith("@")) {
            sql = this.removeStatementHint(sql);
        }
        return this.statementStartsWith(sql, selectStatements);
    }

    @InternalApi
    public boolean isUpdateStatement(String sql) {
        if (sql.startsWith("@")) {
            sql = this.removeStatementHint(sql);
        }
        return this.statementStartsWith(sql, dmlStatements);
    }

    protected abstract boolean supportsExplain();

    private boolean statementStartsWith(String sql, Iterable<String> checkStatements) {
        Preconditions.checkNotNull((Object)sql);
        String[] tokens = sql.split("\\s+", 2);
        int checkIndex = 0;
        if (this.supportsExplain() && tokens[0].equalsIgnoreCase("EXPLAIN")) {
            checkIndex = 1;
        }
        if (tokens.length > checkIndex) {
            for (String check : checkStatements) {
                if (!tokens[checkIndex].equalsIgnoreCase(check)) continue;
                return true;
            }
        }
        return false;
    }

    @InternalApi
    abstract String removeCommentsAndTrimInternal(String var1);

    @InternalApi
    public String removeCommentsAndTrim(String sql) {
        return this.removeCommentsAndTrimInternal(sql);
    }

    abstract String removeStatementHint(String var1);

    @InternalApi
    abstract ParametersInfo convertPositionalParametersToNamedParametersInternal(char var1, String var2);

    @InternalApi
    public ParametersInfo convertPositionalParametersToNamedParameters(char paramChar, String sql) {
        return this.convertPositionalParametersToNamedParametersInternal(paramChar, sql);
    }

    static int countOccurrencesOf(char c, String string) {
        int res = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++res;
        }
        return res;
    }

    @InternalApi
    protected abstract boolean checkReturningClauseInternal(String var1);

    @InternalApi
    public boolean checkReturningClause(String sql) {
        return this.checkReturningClauseInternal(sql);
    }

    @InternalApi
    public static class ParametersInfo {
        public final int numberOfParameters;
        public final String sqlWithNamedParameters;

        ParametersInfo(int numberOfParameters, String sqlWithNamedParameters) {
            this.numberOfParameters = numberOfParameters;
            this.sqlWithNamedParameters = sqlWithNamedParameters;
        }
    }

    @InternalApi
    public static class ParsedStatement {
        private final StatementType type;
        private final ClientSideStatementImpl clientSideStatement;
        private final Statement statement;
        private final String sqlWithoutComments;
        private final boolean returningClause;

        private static ParsedStatement clientSideStatement(ClientSideStatementImpl clientSideStatement, Statement statement, String sqlWithoutComments) {
            return new ParsedStatement(clientSideStatement, statement, sqlWithoutComments);
        }

        private static ParsedStatement ddl(Statement statement, String sqlWithoutComments) {
            return new ParsedStatement(StatementType.DDL, statement, sqlWithoutComments);
        }

        private static ParsedStatement query(Statement statement, String sqlWithoutComments, ExecuteSqlRequest.QueryOptions defaultQueryOptions) {
            return new ParsedStatement(StatementType.QUERY, statement, sqlWithoutComments, defaultQueryOptions, false);
        }

        private static ParsedStatement update(Statement statement, String sqlWithoutComments, boolean returningClause) {
            return new ParsedStatement(StatementType.UPDATE, statement, sqlWithoutComments, returningClause);
        }

        private static ParsedStatement unknown(Statement statement, String sqlWithoutComments) {
            return new ParsedStatement(StatementType.UNKNOWN, statement, sqlWithoutComments);
        }

        private ParsedStatement(ClientSideStatementImpl clientSideStatement, Statement statement, String sqlWithoutComments) {
            Preconditions.checkNotNull((Object)clientSideStatement);
            Preconditions.checkNotNull((Object)statement);
            this.type = StatementType.CLIENT_SIDE;
            this.clientSideStatement = clientSideStatement;
            this.statement = statement;
            this.sqlWithoutComments = sqlWithoutComments;
            this.returningClause = false;
        }

        private ParsedStatement(StatementType type, Statement statement, String sqlWithoutComments, boolean returningClause) {
            this(type, statement, sqlWithoutComments, null, returningClause);
        }

        private ParsedStatement(StatementType type, Statement statement, String sqlWithoutComments) {
            this(type, statement, sqlWithoutComments, null, false);
        }

        private ParsedStatement(StatementType type, Statement statement, String sqlWithoutComments, ExecuteSqlRequest.QueryOptions defaultQueryOptions, boolean returningClause) {
            Preconditions.checkNotNull((Object)((Object)type));
            Preconditions.checkNotNull((Object)statement);
            this.type = type;
            this.clientSideStatement = null;
            this.statement = this.mergeQueryOptions(statement, defaultQueryOptions);
            this.sqlWithoutComments = sqlWithoutComments;
            this.returningClause = returningClause;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.clientSideStatement, this.statement, this.sqlWithoutComments});
        }

        public boolean equals(Object other) {
            if (!(other instanceof ParsedStatement)) {
                return false;
            }
            ParsedStatement o = (ParsedStatement)other;
            return Objects.equals((Object)this.type, (Object)o.type) && Objects.equals(this.clientSideStatement, o.clientSideStatement) && Objects.equals(this.statement, o.statement) && Objects.equals(this.sqlWithoutComments, o.sqlWithoutComments);
        }

        @InternalApi
        public StatementType getType() {
            return this.type;
        }

        @InternalApi
        public boolean hasReturningClause() {
            return this.returningClause;
        }

        @InternalApi
        public boolean isQuery() {
            switch (this.type) {
                case CLIENT_SIDE: {
                    return this.getClientSideStatement().isQuery();
                }
                case QUERY: {
                    return true;
                }
            }
            return false;
        }

        @InternalApi
        public boolean isUpdate() {
            switch (this.type) {
                case CLIENT_SIDE: {
                    return this.getClientSideStatement().isUpdate();
                }
                case UPDATE: {
                    return true;
                }
            }
            return false;
        }

        @InternalApi
        public boolean isDdl() {
            switch (this.type) {
                case DDL: {
                    return true;
                }
            }
            return false;
        }

        @InternalApi
        public StatementResult.ClientSideStatementType getClientSideStatementType() {
            Preconditions.checkState((this.type == StatementType.CLIENT_SIDE ? 1 : 0) != 0);
            return this.clientSideStatement.getStatementType();
        }

        Statement getStatement() {
            return this.statement;
        }

        Statement mergeQueryOptions(Statement statement, ExecuteSqlRequest.QueryOptions defaultQueryOptions) {
            if (defaultQueryOptions == null || defaultQueryOptions.equals((Object)ExecuteSqlRequest.QueryOptions.getDefaultInstance())) {
                return statement;
            }
            if (statement.getQueryOptions() == null) {
                return statement.toBuilder().withQueryOptions(defaultQueryOptions).build();
            }
            return statement.toBuilder().withQueryOptions(defaultQueryOptions.toBuilder().mergeFrom(statement.getQueryOptions()).build()).build();
        }

        @InternalApi
        public String getSqlWithoutComments() {
            return this.sqlWithoutComments;
        }

        ClientSideStatement getClientSideStatement() {
            Preconditions.checkState((this.clientSideStatement != null ? 1 : 0) != 0, (Object)"This ParsedStatement does not contain a ClientSideStatement");
            return this.clientSideStatement;
        }
    }

    @InternalApi
    public static enum StatementType {
        CLIENT_SIDE,
        DDL,
        QUERY,
        UPDATE,
        UNKNOWN;

    }
}

