/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.LinkedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventButton;
import org.eclipse.swt.internal.gtk3.GdkEventKey;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    ImageList imageList;
    int poppedUpCount;
    long menuHandle;
    long modelHandle;
    long actionGroup;
    long shortcutController;
    LinkedList<Section> sections;
    LinkedList<MenuItem> items;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    boolean ableToSetLocation() {
        if (!OS.isX11() && !this.getShell().getVisible()) {
            return false;
        }
        return this.hasLocation;
    }

    void _setVisible(boolean visible) {
        if (visible == GTK.gtk_widget_get_mapped(this.handle)) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                if ((this.parent._getShell().style & 0x4000) != 0 && !GTK.GTK4) {
                    GTK3.gtk_menu_shell_set_take_focus(this.handle, false);
                }
                long eventPtr = 0L;
                if (this.ableToSetLocation()) {
                    if (GTK.GTK4) {
                        GdkRectangle popoverPosition = new GdkRectangle();
                        popoverPosition.x = this.x;
                        popoverPosition.y = this.y;
                        popoverPosition.height = 1;
                        popoverPosition.width = 1;
                        GTK.gtk_popover_set_pointing_to(this.handle, popoverPosition);
                        GTK.gtk_popover_popup(this.handle);
                    } else {
                        eventPtr = GDK.gdk_event_new(4);
                        GdkEventButton event = new GdkEventButton();
                        event.type = 4;
                        event.device = GDK.gdk_get_pointer(GDK.gdk_display_get_default());
                        event.time = this.display.getLastEventTime();
                        GdkRectangle rect = new GdkRectangle();
                        if (OS.isX11()) {
                            event.window = GDK.gdk_display_get_default_group(GDK.gdk_display_get_default());
                            OS.g_object_ref(event.window);
                            GTK3.memmove(eventPtr, event, (long)GdkEventButton.sizeof);
                            int[] globalWindowOriginY = new int[1];
                            int[] globalWindowOriginX = new int[1];
                            GDK.gdk_window_get_origin(event.window, globalWindowOriginX, globalWindowOriginY);
                            rect.x = this.x - globalWindowOriginX[0];
                            rect.y = this.y - globalWindowOriginY[0];
                        } else {
                            long gdkResource = GTK3.gtk_widget_get_window(this.getShell().topHandle());
                            event.window = OS.g_object_ref(gdkResource);
                            GTK3.memmove(eventPtr, event, (long)GdkEventButton.sizeof);
                            rect.x = this.x + 1;
                            rect.y = this.y + 1;
                        }
                        GTK3.gtk_menu_popup_at_rect(this.handle, event.window, rect, 1, 1, eventPtr);
                        this.gdk_event_free(eventPtr);
                    }
                } else {
                    eventPtr = GTK3.gtk_get_current_event();
                    if (eventPtr == 0L) {
                        eventPtr = GDK.gdk_event_new(GTK.GTK4 ? 5 : 4);
                        GdkEventButton event = new GdkEventButton();
                        int n = event.type = GTK.GTK4 ? 5 : 4;
                        if (OS.isX11()) {
                            event.window = OS.g_object_ref(GTK3.gtk_widget_get_window(this.getShell().handle));
                        }
                        event.device = GDK.gdk_get_pointer(GDK.gdk_display_get_default());
                        event.time = this.display.getLastEventTime();
                        GTK3.memmove(eventPtr, event, (long)GdkEventButton.sizeof);
                    }
                    this.adjustParentWindowWayland(eventPtr);
                    this.verifyMenuPosition(this.getItemCount());
                    GTK3.gtk_menu_popup_at_pointer(this.handle, eventPtr);
                    if (GTK.GTK4) {
                        GDK.gdk_event_unref(eventPtr);
                    } else {
                        GDK.gdk_event_free(eventPtr);
                    }
                }
                this.poppedUpCount = this.getItemCount();
            } else {
                this.sendEvent(23);
            }
        } else if (GTK.GTK4) {
            GTK.gtk_popover_popdown(this.handle);
        } else {
            GTK3.gtk_menu_popdown(this.handle);
        }
    }

    void addAccelerators(long accelGroup) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.addAccelerators(accelGroup);
            ++i;
        }
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        if (GTK.GTK4) {
            int bits = 14;
            this.modelHandle = OS.g_menu_new();
            if (this.modelHandle == 0L) {
                this.error(2);
            }
            this.items = new LinkedList();
            this.sections = new LinkedList();
            switch (this.style & bits) {
                case 2: {
                    this.handle = GTK4.gtk_popover_menu_bar_new_from_model(this.modelHandle);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_box_prepend(this.parent.vboxHandle, this.handle);
                    break;
                }
                case 4: {
                    this.handle = this.modelHandle;
                    break;
                }
                default: {
                    this.handle = GTK4.gtk_popover_menu_new_from_model_full(this.modelHandle, 1);
                    GTK.gtk_widget_set_parent(this.handle, this.parent.handle);
                    GTK.gtk_popover_set_position(this.handle, 3);
                    GTK4.gtk_popover_set_has_arrow(this.handle, false);
                    GTK.gtk_widget_set_halign(this.handle, 1);
                    if (this.handle != 0L) break;
                    this.error(2);
                }
            }
            long firstSection = OS.g_menu_new();
            if (firstSection == 0L) {
                this.error(2);
            }
            this.sections.add(new Section(firstSection));
            long defaultSection = OS.g_menu_item_new_section(null, firstSection);
            OS.g_menu_insert_item(this.modelHandle, 0, defaultSection);
            OS.g_object_unref(defaultSection);
            this.actionGroup = OS.g_simple_action_group_new();
            if (this.actionGroup == 0L) {
                this.error(2);
            }
            long shellHandle = this.parent.getShell().topHandle();
            GTK.gtk_widget_insert_action_group(shellHandle, Converter.javaStringToCString(String.valueOf(this.hashCode())), this.actionGroup);
        } else if ((this.style & 2) != 0) {
            this.handle = GTK3.gtk_menu_bar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long vboxHandle = this.parent.vboxHandle;
            GTK3.gtk_container_add(vboxHandle, this.handle);
            this.gtk_box_set_child_packing(vboxHandle, this.handle, false, true, 0, 0);
        } else {
            this.handle = GTK3.gtk_menu_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.menuHandle = this.handle;
            OS.g_object_ref_sink(this.menuHandle);
        }
    }

    @Override
    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations newParent) {
        if (this.isDisposed()) {
            return;
        }
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].fixMenus(newParent);
            ++i;
        }
        this.parent.removeMenu(this);
        newParent.addMenu(this);
        this.parent = newParent;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (GTK.GTK4) {
            if ((this.style & 4) != 0) {
                return true;
            }
            return GTK.gtk_widget_get_sensitive(this.handle);
        }
        return GTK.gtk_widget_get_sensitive(this.handle);
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (GTK.GTK4) {
            if (index < 0 || index >= this.items.size()) {
                this.error(6);
            }
            return this.items.get(index);
        }
        long list = GTK3.gtk_container_get_children(this.handle);
        if (list == 0L) {
            this.error(8);
        }
        int count = OS.g_list_length(list);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        long data = OS.g_list_nth_data(list, index);
        OS.g_list_free(list);
        if (data == 0L) {
            this.error(8);
        }
        return (MenuItem)this.display.getWidget(data);
    }

    public int getItemCount() {
        this.checkWidget();
        if (GTK.GTK4) {
            return this.items.size();
        }
        int count = 0;
        long list = GTK3.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        count = OS.g_list_length(list);
        OS.g_list_free(list);
        return Math.max(0, count);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        if (GTK.GTK4) {
            return this.items.toArray(new MenuItem[this.items.size()]);
        }
        long list = GTK3.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return new MenuItem[0];
        }
        long originalList = list;
        int count = OS.g_list_length(list);
        MenuItem[] items = new MenuItem[count];
        int index = 0;
        int i = 0;
        while (i < count) {
            long data = OS.g_list_data(list);
            MenuItem item = (MenuItem)this.display.getWidget(data);
            if (item != null) {
                items[index++] = item;
            }
            list = OS.g_list_next(list);
            ++i;
        }
        OS.g_list_free(originalList);
        if (index != items.length) {
            MenuItem[] newItems = new MenuItem[index];
            System.arraycopy(items, 0, newItems, 0, index);
            items = newItems;
        }
        return items;
    }

    @Override
    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] popups;
        this.checkWidget();
        if ((this.style & 8) != 0 && (popups = this.display.popups) != null) {
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return GTK.gtk_widget_get_mapped(this.handle);
    }

    @Override
    long gtk_hide(long widget) {
        if ((this.style & 8) != 0 && this.display.activeShell != null) {
            this.display.activeShell = this.getShell();
            if (this.display.activeShell.ignoreFocusOut) {
                this.display.activeShell.ignoreFocusIn = true;
            }
            this.display.activeShell.ignoreFocusOut = false;
        }
        this.sendEvent(23);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                MenuItem item = items[i];
                if (item.updateAcceleratorText(false)) {
                    // empty if block
                }
                ++i;
            }
        }
        return 0L;
    }

    @Override
    long gtk_show(long widget) {
        if ((this.style & 8) != 0) {
            if (this.display.activeShell != null) {
                this.display.activeShell = this.getShell();
                this.display.activeShell.ignoreFocusOut = true;
            }
            return 0L;
        }
        this.sendEvent(22);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                MenuItem item = items[i];
                if (item.updateAcceleratorText(true)) {
                    // empty if block
                }
                ++i;
            }
        }
        return 0L;
    }

    @Override
    long gtk3_show_help(long widget, long helpType) {
        if (this.sendHelpEvent(helpType)) {
            GTK3.gtk_menu_shell_deactivate(this.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_menu_popped_up(long widget, long flipped_rect, long final_rect, long flipped_x, long flipped_y) {
        GdkRectangle finalRect = new GdkRectangle();
        OS.memmove(finalRect, final_rect, (long)GDK.GdkRectangle_sizeof());
        GdkRectangle flippedRect = new GdkRectangle();
        OS.memmove(flippedRect, flipped_rect, (long)GDK.GdkRectangle_sizeof());
        boolean flippedX = flipped_x == 1L;
        boolean flippedY = flipped_y == 1L;
        System.out.println("SWT_MENU_LOCATION_DEBUGGING enabled, printing positioning info for " + widget);
        if (!OS.isX11()) {
            System.out.println("Note: SWT is running on Wayland, coordinates will be parent-relative");
        }
        if (this.hasLocation) {
            System.out.println("hasLocation is true and set coordinates are Point {" + this.x + ", " + this.y + "}");
        } else {
            System.out.println("hasLocation is not set, this is most likely a right click menu");
        }
        if (flippedX) {
            System.out.println("Menu is inverted along the X-axis");
        }
        if (flippedY) {
            System.out.println("Menu is inverted along the Y-axis");
        }
        System.out.println("Final menu position and size is Rectangle {" + finalRect.x + ", " + finalRect.y + ", " + finalRect.width + ", " + finalRect.height + "}");
        System.out.println("Flipped menu position and size is Rectangle {" + flippedRect.x + ", " + flippedRect.y + ", " + flippedRect.width + ", " + flippedRect.height + "}");
        System.out.println("");
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4) {
            this.shortcutController = GTK4.gtk_shortcut_controller_new();
            if (this.shortcutController == 0L) {
                this.error(2);
            }
            GTK4.gtk_shortcut_controller_set_scope(this.shortcutController, 2);
            GTK4.gtk_widget_add_controller(this.parent.handle, this.shortcutController);
            if ((this.style & 4) == 0) {
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
            }
        } else {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
            if (OS.SWT_MENU_LOCATION_DEBUGGING) {
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[85], 0, this.display.getClosure(85), false);
            }
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
        }
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseChildren(boolean destroy) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void destroyWidget() {
        super.destroyWidget();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
            this.menuHandle = 0L;
        }
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void removeAccelerators(long accelGroup) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.removeAccelerators(accelGroup);
            ++i;
        }
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    @Override
    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }

    boolean sendHelpEvent(long helpType) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(helpType);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (GTK.GTK4) {
            if ((this.style & 4) != 0) {
                return;
            }
            GTK.gtk_widget_set_sensitive(this.handle, enabled);
        } else {
            GTK.gtk_widget_set_sensitive(this.handle, enabled);
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setLocation(new Point(x, y));
    }

    void setLocationInPixels(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(location));
    }

    void setLocationInPixels(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocationInPixels(location.x, location.y);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(orientation);
    }

    void _setOrientation(int orientation) {
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.setOrientation(false);
    }

    @Override
    void setOrientation(boolean create) {
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, dir);
            }
            MenuItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setOrientation(create);
                ++i;
            }
        }
    }

    void adjustParentWindowWayland(long eventPtr) {
        if (!OS.isX11()) {
            long display = GDK.gdk_display_get_default();
            long pointer = GDK.gdk_get_pointer(display);
            long deviceResource = GTK.GTK4 ? GDK.gdk_device_get_surface_at_position(pointer, null, null) : GDK.gdk_device_get_window_at_position(pointer, null, null);
            OS.g_object_ref(deviceResource);
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Control.fixGdkEventTypeValues(eventType);
            switch (eventType) {
                case 4: {
                    GdkEventButton eventButton = new GdkEventButton();
                    GTK3.memmove(eventButton, eventPtr, (long)GdkEventButton.sizeof);
                    eventButton.window = deviceResource;
                    GTK3.memmove(eventPtr, eventButton, (long)GdkEventButton.sizeof);
                    break;
                }
                case 8: {
                    GdkEventKey eventKey = new GdkEventKey();
                    GTK3.memmove(eventKey, eventPtr, (long)GdkEventKey.sizeof);
                    eventKey.window = deviceResource;
                    GTK3.memmove(eventPtr, eventKey, (long)GdkEventKey.sizeof);
                }
            }
        }
    }

    void verifyMenuPosition(int itemCount) {
        if (OS.isX11() && itemCount != this.poppedUpCount && this.poppedUpCount != 0) {
            int[] naturalHeight = new int[1];
            GTK.gtk_widget_show(this.handle);
            GTK3.gtk_widget_get_preferred_height(this.handle, null, naturalHeight);
            if (naturalHeight[0] > 0 && !GTK.GTK4) {
                long topLevelWidget = GTK3.gtk_widget_get_toplevel(this.handle);
                long topLevelWindow = GTK3.gtk_widget_get_window(topLevelWidget);
                int width = GDK.gdk_window_get_width(topLevelWindow);
                GDK.gdk_window_resize(topLevelWindow, width, naturalHeight[0]);
            }
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    class Section {
        LinkedList<MenuItem> sectionItems = new LinkedList();
        private MenuItem separator;
        private long sectionHandle;

        public Section() {
        }

        public Section(MenuItem separator) {
            this();
            this.separator = separator;
        }

        public Section(long sectionHandle) {
            this();
            this.sectionHandle = sectionHandle;
        }

        public long getSectionHandle() {
            return this.sectionHandle != 0L ? this.sectionHandle : this.separator.modelHandle;
        }

        public int getItemPosition(MenuItem item) {
            return this.sectionItems.indexOf(item);
        }

        public int getSectionSize() {
            return this.sectionItems.size();
        }

        public int getSectionPosition() {
            return Menu.this.items.indexOf(this.separator);
        }
    }
}

