/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.validator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.ValidatorContext;

public class FileExistsValidator
extends AbstractFileValidator {
    public static final FileExistsValidator INSTANCE = new FileExistsValidator();
    static final String VALIDATOR_NAME = "fileExists";
    private static final String KEY_FAIL_IF_DOES_NOT_EXIST = "org.apache.hop.workflow.actions.createfile.failIfDoesNotExist";

    @Override
    public boolean validate(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, ValidatorContext context) {
        String filename = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        IVariables variables = this.getVariableSpace(source, propertyName, remarks, context);
        boolean failIfDoesNotExist = this.getFailIfDoesNotExist(source, propertyName, remarks, context);
        if (null == variables) {
            return false;
        }
        String realFileName = variables.resolve(filename);
        FileObject fileObject = null;
        try {
            fileObject = HopVfs.getFileObject((String)realFileName);
            if (fileObject == null || fileObject != null && !fileObject.exists() && failIfDoesNotExist) {
                ActionValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, ActionValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
                return false;
            }
            try {
                fileObject.close();
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            ActionValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }

    public static ValidatorContext putFailIfDoesNotExist(boolean failIfDoesNotExist) {
        ValidatorContext context = new ValidatorContext();
        context.put(KEY_FAIL_IF_DOES_NOT_EXIST, failIfDoesNotExist);
        return context;
    }

    protected boolean getFailIfDoesNotExist(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, ValidatorContext context) {
        Object obj = context.get(KEY_FAIL_IF_DOES_NOT_EXIST);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void putFailIfDoesNotExist(ValidatorContext context, boolean failIfDoesNotExist) {
        context.put(KEY_FAIL_IF_DOES_NOT_EXIST, failIfDoesNotExist);
    }
}

