/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.injector;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class InjectorField {
    @HopMetadataProperty(key="name")
    private String name;
    @HopMetadataProperty
    private String type;
    @HopMetadataProperty
    private String length;
    @HopMetadataProperty
    private String precision;

    public InjectorField() {
    }

    public InjectorField(String name, String type, String length, String precision) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
    }

    public InjectorField(InjectorField f) {
        this.name = f.name;
        this.type = f.type;
        this.length = f.length;
        this.precision = f.precision;
    }

    public IValueMeta createValueMeta(IVariables variables) throws HopException {
        String name = variables.resolve(this.name);
        int type = ValueMetaFactory.getIdForValueMeta((String)variables.resolve(this.type));
        int length = Const.toInt((String)variables.resolve(this.length), (int)-1);
        int precision = Const.toInt((String)variables.resolve(this.precision), (int)-1);
        IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)name, (int)type, (int)length, (int)precision);
        return valueMeta;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }
}

