/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.util.Assert;

public class KeyValue<T>
implements Serializable {
    public static final List<String> DEFAULT_TRUE_VALUES = List.of("j", "y", "on", "true");
    public static final String VALID_KEY_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789_-";
    private static final long serialVersionUID = -6847244072467344205L;
    private final String key;
    private T value;

    public KeyValue(String key, T value) throws IllegalArgumentException {
        String keyToSet = StringUtils.lowerCase((String)key);
        KeyValue.assertKey(keyToSet);
        this.key = keyToSet;
        this.value = value;
    }

    public KeyValue(String key) throws IllegalArgumentException {
        this(key, null);
    }

    public static final void assertKey(String lowerKey) throws IllegalArgumentException {
        Assert.assertNotEmpty(lowerKey, "Key cannot be null or empty");
        if (!StringUtils.containsOnly((String)lowerKey, (String)VALID_KEY_CHARS)) {
            throw new IllegalArgumentException("Key contains invalid characters [validKeyCharacters=abcdefghijklmnopqrstuvwxyz0123456789_-]");
        }
        if (lowerKey.charAt(0) == '-') {
            throw new IllegalArgumentException("Key must not start with '-'");
        }
        if (lowerKey.endsWith("-")) {
            throw new IllegalArgumentException("Key must not end with '-'");
        }
        if ("_".equals(lowerKey)) {
            throw new IllegalArgumentException("Key must not be  '_'");
        }
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public KeyValue<T> value(T newValue) {
        this.value = newValue;
        return this;
    }

    public T value() {
        return this.value;
    }

    public Boolean booleanValue(String ... trueValues) {
        return this.booleanValue(Arrays.asList(trueValues));
    }

    public Boolean booleanValue(List<String> trueValues) {
        return this.booleanValue(trueValues, true);
    }

    public Boolean booleanValue(List<String> trueValues, boolean ignoreCase) {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        String stringValue = this.stringValue();
        if (ignoreCase) {
            return trueValues.contains(StringUtils.lowerCase((String)stringValue));
        }
        return trueValues.contains(stringValue);
    }

    public Boolean booleanValue() {
        return this.booleanValue(DEFAULT_TRUE_VALUES, true);
    }

    public Boolean booleanValue(Boolean defaultValue) {
        Boolean returnValue = this.booleanValue();
        if (returnValue == null) {
            return defaultValue;
        }
        return returnValue;
    }

    public String stringValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return String.valueOf(this.value);
    }

    public String stringValue(String defaultValue) {
        String returnValue = this.stringValue();
        if (returnValue == null) {
            return defaultValue;
        }
        return returnValue;
    }

    public String stringValueDefaultIfBlank(String defaultValue) {
        String returnValue = this.stringValue();
        if (StringUtils.isBlank((String)returnValue)) {
            return defaultValue;
        }
        return returnValue;
    }

    public Integer integerValue() throws NumberFormatException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return Integer.valueOf(String.valueOf(this.value));
    }

    public Integer integerValue(Integer defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        try {
            return this.integerValue();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Long longValue() throws NumberFormatException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        return Long.valueOf(String.valueOf(this.value));
    }

    public Long longValue(Long defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        try {
            return this.longValue();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Double doubleValue() throws NumberFormatException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        return Double.valueOf(String.valueOf(this.value));
    }

    public Double doubleValue(Double defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        try {
            return this.doubleValue();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Float floatValue() throws NumberFormatException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Float) {
            return (Float)this.value;
        }
        return Float.valueOf(String.valueOf(this.value));
    }

    public Float floatValue(Float defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        try {
            return this.floatValue();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(KeyValue.class.getSimpleName());
        builder.append('(');
        builder.append(this.key);
        if (this.value == null) {
            builder.append("<null>)");
        } else {
            builder.append("=[");
            builder.append(this.value);
            builder.append("])");
        }
        return builder.toString();
    }
}

