/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.ComponentClosingUtils;
import org.apache.flink.runtime.operators.coordination.CoordinatorStore;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecreateOnResetOperatorCoordinator
implements OperatorCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(RecreateOnResetOperatorCoordinator.class);
    private static final long CLOSING_TIMEOUT_MS = 60000L;
    private final Provider provider;
    private final long closingTimeoutMs;
    private final OperatorCoordinator.Context context;
    private DeferrableCoordinator coordinator;
    private boolean started;
    private volatile boolean closed;

    private RecreateOnResetOperatorCoordinator(OperatorCoordinator.Context context, Provider provider, long closingTimeoutMs) throws Exception {
        this.context = context;
        this.provider = provider;
        this.coordinator = new DeferrableCoordinator(context.getOperatorId());
        this.coordinator.createNewInternalCoordinator(context, provider);
        this.coordinator.processPendingCalls();
        this.closingTimeoutMs = closingTimeoutMs;
        this.started = false;
        this.closed = false;
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"coordinator already started");
        this.started = true;
        this.coordinator.applyCall("start", OperatorCoordinator::start);
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.coordinator.closeAsync(this.closingTimeoutMs);
    }

    @Override
    public void handleEventFromOperator(int subtask, OperatorEvent event) throws Exception {
        this.coordinator.applyCall("handleEventFromOperator", c -> c.handleEventFromOperator(subtask, event));
    }

    @Override
    public void subtaskFailed(int subtask, @Nullable Throwable reason) {
        this.coordinator.applyCall("subtaskFailed", c -> c.subtaskFailed(subtask, reason));
    }

    @Override
    public void subtaskReset(int subtask, long checkpointId) {
        this.coordinator.applyCall("subtaskReset", c -> c.subtaskReset(subtask, checkpointId));
    }

    @Override
    public void subtaskReady(int subtask, OperatorCoordinator.SubtaskGateway gateway) {
        this.coordinator.applyCall("subtaskReady", c -> c.subtaskReady(subtask, gateway));
    }

    @Override
    public void checkpointCoordinator(long checkpointId, CompletableFuture<byte[]> resultFuture) throws Exception {
        this.coordinator.applyCall("checkpointCoordinator", c -> c.checkpointCoordinator(checkpointId, resultFuture));
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
        this.coordinator.applyCall("checkpointComplete", c -> c.notifyCheckpointComplete(checkpointId));
    }

    @Override
    public void resetToCheckpoint(long checkpointId, @Nullable byte[] checkpointData) {
        DeferrableCoordinator newCoordinator;
        LOG.info("Resetting coordinator to checkpoint.");
        DeferrableCoordinator oldCoordinator = this.coordinator;
        this.coordinator = newCoordinator = new DeferrableCoordinator(this.context.getOperatorId());
        CompletableFuture<Void> closingFuture = oldCoordinator.closeAsync(this.closingTimeoutMs);
        boolean wasStarted = this.started;
        closingFuture.whenComplete((ignored, e) -> {
            if (e != null) {
                LOG.warn(String.format("Received exception when closing operator coordinator for %s.", new Object[]{oldCoordinator.operatorId}), e);
            }
            if (!this.closed) {
                newCoordinator.createNewInternalCoordinator(this.context, this.provider);
                newCoordinator.resetAndStart(checkpointId, checkpointData, wasStarted);
                newCoordinator.processPendingCalls();
            }
        });
    }

    @VisibleForTesting
    public OperatorCoordinator getInternalCoordinator() throws Exception {
        this.waitForAllAsyncCallsFinish();
        return this.coordinator.internalCoordinator;
    }

    @VisibleForTesting
    QuiesceableContext getQuiesceableContext() throws Exception {
        this.waitForAllAsyncCallsFinish();
        return this.coordinator.internalQuiesceableContext;
    }

    @VisibleForTesting
    void waitForAllAsyncCallsFinish() throws Exception {
        CompletableFuture future = new CompletableFuture();
        this.coordinator.applyCall("waitForAllAsyncCallsFinish", c -> future.complete(null));
        future.get();
    }

    private static class NamedCall {
        private final String name;
        private final ThrowingConsumer<OperatorCoordinator, ?> consumer;

        private NamedCall(String name, ThrowingConsumer<OperatorCoordinator, ?> consumer) {
            this.name = name;
            this.consumer = consumer;
        }

        public String getName() {
            return this.name;
        }

        public ThrowingConsumer<OperatorCoordinator, ?> getConsumer() {
            return this.consumer;
        }
    }

    private static class DeferrableCoordinator {
        private final OperatorID operatorId;
        private final BlockingQueue<NamedCall> pendingCalls;
        private QuiesceableContext internalQuiesceableContext;
        private OperatorCoordinator internalCoordinator;
        private boolean hasCaughtUp;
        private boolean closed;
        private volatile boolean failed;

        private DeferrableCoordinator(OperatorID operatorId) {
            this.operatorId = operatorId;
            this.pendingCalls = new LinkedBlockingQueue<NamedCall>();
            this.hasCaughtUp = false;
            this.closed = false;
            this.failed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized <T extends Exception> void applyCall(String name, ThrowingConsumer<OperatorCoordinator, T> call) throws T {
            DeferrableCoordinator deferrableCoordinator = this;
            synchronized (deferrableCoordinator) {
                if (this.hasCaughtUp) {
                    call.accept((Object)this.internalCoordinator);
                } else {
                    this.pendingCalls.add(new NamedCall(name, call));
                }
            }
        }

        synchronized void createNewInternalCoordinator(OperatorCoordinator.Context context, Provider provider) {
            if (this.closed) {
                return;
            }
            try {
                this.internalQuiesceableContext = new QuiesceableContext(context);
                this.internalCoordinator = provider.getCoordinator(this.internalQuiesceableContext);
            }
            catch (Exception e) {
                LOG.error("Failed to create new internal coordinator due to ", (Throwable)e);
                this.cleanAndFailJob(e);
            }
        }

        synchronized CompletableFuture<Void> closeAsync(long timeoutMs) {
            this.closed = true;
            if (this.internalCoordinator != null) {
                this.internalQuiesceableContext.quiesce();
                this.pendingCalls.clear();
                return ComponentClosingUtils.closeAsyncWithTimeout("SourceCoordinator for " + (Object)((Object)this.operatorId), (ThrowingRunnable<Exception>)((ThrowingRunnable)this.internalCoordinator::close), Duration.ofMillis(timeoutMs)).exceptionally(e -> {
                    this.cleanAndFailJob((Throwable)e);
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void processPendingCalls() {
            if (this.failed || this.closed || this.internalCoordinator == null) {
                return;
            }
            String name = "Unknown Call Name";
            try {
                while (!this.hasCaughtUp) {
                    Object namedCall;
                    while (!this.pendingCalls.isEmpty()) {
                        namedCall = (NamedCall)this.pendingCalls.poll();
                        if (namedCall == null) continue;
                        name = ((NamedCall)namedCall).name;
                        ((NamedCall)namedCall).getConsumer().accept((Object)this.internalCoordinator);
                    }
                    namedCall = this;
                    synchronized (namedCall) {
                        if (this.pendingCalls.isEmpty()) {
                            this.hasCaughtUp = true;
                        }
                    }
                }
                return;
            }
            catch (Throwable t) {
                LOG.error("Failed to process pending calls {} on coordinator.", (Object)name, (Object)t);
                this.cleanAndFailJob(t);
            }
        }

        void start() throws Exception {
            this.internalCoordinator.start();
        }

        void resetAndStart(long checkpointId, @Nullable byte[] checkpointData, boolean started) {
            if (this.failed || this.closed || this.internalCoordinator == null) {
                return;
            }
            try {
                this.internalCoordinator.resetToCheckpoint(checkpointId, checkpointData);
                if (started) {
                    this.internalCoordinator.start();
                }
            }
            catch (Exception e) {
                LOG.error("Failed to reset the coordinator to checkpoint and start.", (Throwable)e);
                this.cleanAndFailJob(e);
            }
        }

        private void cleanAndFailJob(Throwable t) {
            if (!this.failed) {
                this.failed = true;
                this.internalQuiesceableContext.getContext().failJob(t);
                this.pendingCalls.clear();
            }
        }
    }

    @VisibleForTesting
    static class QuiesceableContext
    implements OperatorCoordinator.Context {
        private final OperatorCoordinator.Context context;
        private volatile boolean quiesced;

        QuiesceableContext(OperatorCoordinator.Context context) {
            this.context = context;
            this.quiesced = false;
        }

        @Override
        public OperatorID getOperatorId() {
            return this.context.getOperatorId();
        }

        @Override
        public synchronized void failJob(Throwable cause) {
            if (this.quiesced) {
                return;
            }
            this.context.failJob(cause);
        }

        @Override
        public int currentParallelism() {
            return this.context.currentParallelism();
        }

        @Override
        public ClassLoader getUserCodeClassloader() {
            return this.context.getUserCodeClassloader();
        }

        @Override
        public CoordinatorStore getCoordinatorStore() {
            return this.context.getCoordinatorStore();
        }

        @VisibleForTesting
        synchronized void quiesce() {
            this.quiesced = true;
        }

        @VisibleForTesting
        boolean isQuiesced() {
            return this.quiesced;
        }

        private OperatorCoordinator.Context getContext() {
            return this.context;
        }
    }

    public static abstract class Provider
    implements OperatorCoordinator.Provider {
        private static final long serialVersionUID = 3002837631612629071L;
        private final OperatorID operatorID;

        public Provider(OperatorID operatorID) {
            this.operatorID = operatorID;
        }

        @Override
        public OperatorID getOperatorId() {
            return this.operatorID;
        }

        @Override
        public OperatorCoordinator create(OperatorCoordinator.Context context) throws Exception {
            return this.create(context, 60000L);
        }

        @VisibleForTesting
        protected OperatorCoordinator create(OperatorCoordinator.Context context, long closingTimeoutMs) throws Exception {
            return new RecreateOnResetOperatorCoordinator(context, this, closingTimeoutMs);
        }

        protected abstract OperatorCoordinator getCoordinator(OperatorCoordinator.Context var1) throws Exception;
    }
}

