/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;

@Internal
public class InternalSinkWriterMetricGroup
extends ProxyMetricGroup<MetricGroup>
implements SinkWriterMetricGroup {
    private final Counter numRecordsOutErrors;
    private final Counter numRecordsSendErrors;
    private final Counter numRecordsWritten;
    private final Counter numBytesWritten;
    private final OperatorIOMetricGroup operatorIOMetricGroup;

    private InternalSinkWriterMetricGroup(MetricGroup parentMetricGroup, OperatorIOMetricGroup operatorIOMetricGroup) {
        super(parentMetricGroup);
        this.numRecordsOutErrors = parentMetricGroup.counter("numRecordsOutErrors");
        this.numRecordsSendErrors = parentMetricGroup.counter("numRecordsSendErrors", this.numRecordsOutErrors);
        this.numRecordsWritten = parentMetricGroup.counter("numRecordsSend", operatorIOMetricGroup.getNumRecordsOutCounter());
        this.numBytesWritten = parentMetricGroup.counter("numBytesSend", operatorIOMetricGroup.getNumBytesOutCounter());
        this.operatorIOMetricGroup = operatorIOMetricGroup;
    }

    public static InternalSinkWriterMetricGroup wrap(OperatorMetricGroup operatorMetricGroup) {
        return new InternalSinkWriterMetricGroup((MetricGroup)operatorMetricGroup, operatorMetricGroup.getIOMetricGroup());
    }

    @VisibleForTesting
    public static InternalSinkWriterMetricGroup mock(MetricGroup metricGroup) {
        return new InternalSinkWriterMetricGroup(metricGroup, UnregisteredMetricsGroup.createOperatorIOMetricGroup());
    }

    @VisibleForTesting
    public static InternalSinkWriterMetricGroup mock(MetricGroup metricGroup, OperatorIOMetricGroup operatorIOMetricGroup) {
        return new InternalSinkWriterMetricGroup(metricGroup, operatorIOMetricGroup);
    }

    public OperatorIOMetricGroup getIOMetricGroup() {
        return this.operatorIOMetricGroup;
    }

    public Counter getNumRecordsOutErrorsCounter() {
        return this.numRecordsOutErrors;
    }

    public Counter getNumRecordsSendErrorsCounter() {
        return this.numRecordsSendErrors;
    }

    public Counter getNumRecordsSendCounter() {
        return this.numRecordsWritten;
    }

    public Counter getNumBytesSendCounter() {
        return this.numBytesWritten;
    }

    public void setCurrentSendTimeGauge(Gauge<Long> currentSendTimeGauge) {
        this.parentMetricGroup.gauge("currentSendTime", currentSendTimeGauge);
    }
}

