/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class SubpartitionIndexRange
implements Serializable {
    private final int startIndex;
    private final int endIndex;

    public SubpartitionIndexRange(int startIndex, int endIndex) {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((endIndex >= startIndex ? 1 : 0) != 0);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int size() {
        return this.endIndex - this.startIndex + 1;
    }

    public String toString() {
        return String.format("[%d, %d]", this.startIndex, this.endIndex);
    }
}

