/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delete;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.delete.Delete;
import org.apache.hop.pipeline.transforms.delete.DeleteData;
import org.apache.hop.pipeline.transforms.delete.DeleteKeyField;
import org.apache.hop.pipeline.transforms.delete.DeleteLookupField;

@Transform(id="Delete", image="delete.svg", name="i18n::Delete.Name", description="i18n::Delete.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::DeleteMeta.keyword"}, documentationUrl="/pipeline/transforms/delete.html")
public class DeleteMeta
extends BaseTransformMeta<Delete, DeleteData> {
    private static final Class<?> PKG = DeleteMeta.class;
    @HopMetadataProperty(key="lookup")
    private DeleteLookupField lookup;
    @HopMetadataProperty(key="connection", injectionKeyDescription="Delete.Injection.Connection")
    private String connection;
    @HopMetadataProperty(key="commit", injectionKeyDescription="Delete.Injection.CommitSize.Field")
    private String commitSize;

    public DeleteMeta() {
        this.lookup = new DeleteLookupField();
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getCommitSizeVar() {
        return this.commitSize;
    }

    public DeleteLookupField getLookup() {
        return this.lookup;
    }

    public void setLookup(DeleteLookupField lookup) {
        this.lookup = lookup;
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public int getCommitSize(IVariables vs) {
        this.commitSize = this.commitSize == null ? "0" : this.commitSize;
        return Integer.parseInt(vs.resolve(this.commitSize));
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public DeleteMeta(DeleteMeta obj) {
        this.connection = obj.connection;
        this.commitSize = obj.commitSize;
        this.lookup = new DeleteLookupField(obj.lookup);
    }

    public Object clone() {
        return new DeleteMeta(this);
    }

    public void setDefault() {
        this.commitSize = "100";
        this.lookup.setSchemaName("");
        this.lookup.setTableName(BaseMessages.getString(PKG, (String)"DeleteMeta.DefaultTableName.Label", (String[])new String[0]));
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.DatabaseMetaError", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, variables, databaseMeta);
            try {
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.lookup.getTableName())) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.TablenameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    IRowMeta r = db.getTableFieldsMeta(this.lookup.getSchemaName(), this.lookup.getTableName());
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.VisitTableSuccessfully", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        List<DeleteKeyField> keyFields = this.lookup.getFields();
                        for (int i = 0; i < keyFields.size(); ++i) {
                            String lufield = keyFields.get(i).getKeyLookup();
                            IValueMeta v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + lufield + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.FoundLookupFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    IValueMeta v;
                    int i;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.ConnectedTransformSuccessfully", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    List<DeleteKeyField> keyFields = this.lookup.getFields();
                    for (i = 0; i < keyFields.size(); ++i) {
                        String keyStr = keyFields.get(i).getKeyStream();
                        v = prev.searchValueMeta(keyStr);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + keyStr + Const.CR;
                    }
                    for (i = 0; i < keyFields.size(); ++i) {
                        String keyStr2 = keyFields.get(i).getKeyStream2();
                        if (StringUtils.isEmpty((String)keyStr2) || (v = prev.searchValueMeta(keyStr2)) != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.MissingFields2", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + keyStr2 + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.MissingFields3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.DatabaseError", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.TransformReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retval;
        block13: {
            DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
            retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
            if (databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    if (!Utils.isEmpty((CharSequence)this.lookup.getTableName())) {
                        Database db = new Database(loggingObject, variables, databaseMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.lookup.getSchemaName(), this.lookup.getTableName());
                            String crTable = db.getDDL(schemaTable, prev, null, false, null, true);
                            String crIndex = "";
                            String[] idxFields = null;
                            List<DeleteKeyField> keyFields = this.lookup.getFields();
                            if (keyFields.size() > 0) {
                                idxFields = new String[keyFields.size()];
                                for (int i = 0; i < keyFields.size(); ++i) {
                                    idxFields[i] = keyFields.get(i).getKeyLookup();
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"DeleteMeta.CheckResult.KeyFieldsRequired", (String[])new String[0]));
                            }
                            if (idxFields != null && idxFields.length > 0 && !db.checkIndexExists(schemaTable, idxFields)) {
                                String indexname = "idx_" + this.lookup.getTableName() + "_lookup";
                                crIndex = db.getCreateIndexStatement(this.lookup.getSchemaName(), this.lookup.getTableName(), indexname, idxFields, false, false, false, true);
                            }
                            if ((sql = crTable + crIndex).length() == 0) {
                                retval.setSql(null);
                                break block13;
                            }
                            retval.setSql(sql);
                        }
                        catch (HopException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"DeleteMeta.Returnvalue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"DeleteMeta.Returnvalue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"DeleteMeta.Returnvalue.NoReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"DeleteMeta.Returnvalue.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (prev != null) {
            List<DeleteKeyField> keyFields = this.lookup.getFields();
            for (int i = 0; i < keyFields.size(); ++i) {
                String keyStr = keyFields.get(i).getKeyStream();
                IValueMeta v = prev.searchValueMeta(keyStr);
                try {
                    DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                    DatabaseImpact ii = new DatabaseImpact(5, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.lookup.getTableName(), keyFields.get(i).getKeyLookup(), keyFields.get(i).getKeyStream(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                    continue;
                }
                catch (HopException e) {
                    throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
                }
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

