/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableinput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.tableinput.TableInput;
import org.apache.hop.pipeline.transforms.tableinput.TableInputData;
import org.w3c.dom.Node;

@Transform(id="TableInput", image="tableinput.svg", name="i18n::TableInput.Name", description="i18n::TableInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/tableinput.html", keywords={"i18n::TableInputMeta.keyword"})
public class TableInputMeta
extends BaseTransformMeta<TableInput, TableInputData> {
    private static final Class<?> PKG = TableInputMeta.class;
    @HopMetadataProperty(key="sql", injectionKey="SQL")
    private String sql;
    @HopMetadataProperty(key="limit", injectionKey="LIMIT")
    private String rowLimit;
    @HopMetadataProperty(key="execute_each_row", injectionKey="EXECUTE_FOR_EACH_ROW")
    private boolean executeEachInputRow;
    @HopMetadataProperty(key="variables_active", injectionKey="REPLACE_VARIABLES")
    private boolean variableReplacementActive;
    @HopMetadataProperty(key="connection", injectionKey="CONNECTIONNAME")
    private String connection;
    @HopMetadataProperty
    private String lookup;

    public boolean isExecuteEachInputRow() {
        return this.executeEachInputRow;
    }

    public void setExecuteEachInputRow(boolean oncePerRow) {
        this.executeEachInputRow = oncePerRow;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getLookup() {
        return this.lookup;
    }

    public void setLookup(String lookup) {
        this.lookup = lookup;
    }

    public Object clone() {
        TableInputMeta retval = (TableInputMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.sql = "SELECT <values> FROM <table name> WHERE <conditions>";
        this.rowLimit = "0";
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        boolean param = false;
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
        }
        Database db = new Database(loggingObject, variables, databaseMeta);
        this.databases = new Database[]{db};
        String sNewSql = this.sql;
        if (this.isVariableReplacementActive()) {
            sNewSql = db.resolve(this.sql);
            if (variables != null) {
                sNewSql = variables.resolve(sNewSql);
            }
        }
        IRowMeta add = null;
        try {
            add = db.getQueryFields(sNewSql, param);
        }
        catch (HopDatabaseException dbe) {
            throw new HopTransformException("Unable to get queryfields for SQL: " + Const.CR + sNewSql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                IValueMeta v = add.getValueMeta(i);
                v.setOrigin(origin);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                IRowMeta paramRowMeta = null;
                Object[] paramData = null;
                IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
                if (!Utils.isEmpty((CharSequence)infoStream.getTransformName())) {
                    param = true;
                    if (info.length > 0 && info[0] != null) {
                        paramRowMeta = info[0];
                        paramData = RowDataUtil.allocateRowData((int)paramRowMeta.size());
                    }
                }
                if ((add = db.getQueryFields(sNewSql, param, paramRowMeta, paramData)) == null) {
                    return;
                }
                for (int i = 0; i < add.size(); ++i) {
                    IValueMeta v = add.getValueMeta(i);
                    v.setOrigin(origin);
                }
                row.addRowMeta(add);
            }
            catch (HopException ke) {
                throw new HopTransformException("Unable to get queryfields for SQL: " + Const.CR + sNewSql, (Throwable)ke);
            }
            finally {
                db.disconnect();
            }
        }
    }

    public String getXml() throws HopException {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        this.lookup = ((IStream)infoStreams.get(0)).getTransformName();
        return super.getXml();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        infoStream.setSubject(this.lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableInputMeta.CheckResult.DatabaseMetaError", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (databaseMeta != null) {
            cr = new CheckResult(1, "Connection exists", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Database db = new Database(loggingObject, variables, databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, "Connection to database OK", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, "SQL statement is entered", (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                cr = new CheckResult(4, "SQL statement is missing.", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        if (!Utils.isEmpty((CharSequence)infoStream.getTransformName())) {
            boolean found = false;
            for (int i = 0; i < input.length; ++i) {
                if (!infoStream.getTransformName().equalsIgnoreCase(input[i])) continue;
                found = true;
            }
            if (found) {
                cr = new CheckResult(1, "Previous transform to read info from [" + infoStream.getTransformName() + "] is found.", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, "Previous transform to read info from [" + infoStream.getTransformName() + "] is not found.", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            int count = 0;
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if (c == '\'') {
                    while ((c = this.sql.charAt(++i)) != '\'') {
                    }
                }
                if (c != '?') continue;
                ++count;
            }
            if (info != null) {
                if (count == info.size()) {
                    cr = new CheckResult(1, "This transform is expecting and receiving " + info.size() + " fields of input from the previous transform.", (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, "This transform is receiving " + info.size() + " but not the expected " + count + " fields of input from the previous transform.", (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, "Input transform name is not recognized!", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, "Transform is not expecting info from input transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "No input expected, no input provided.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            RowMeta out = new RowMeta();
            this.getFields((IRowMeta)out, transformMeta.getName(), new IRowMeta[]{info}, null, variables, metadataProvider);
            if (out != null) {
                for (int i = 0; i < out.size(); ++i) {
                    IValueMeta outvalue = out.getValueMeta(i);
                    DatabaseImpact ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), transformMeta.getName(), this.sql, "read from one or more database tables via SQL statement");
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
        }
    }

    public boolean isVariableReplacementActive() {
        return this.variableReplacementActive;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.variableReplacementActive = variableReplacementActive;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"TableInputMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, this.lookup);
            ioMeta.addStream((IStream)stream);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }
}

