/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.compression.ICompressor;
import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.CipherInputStream;
import com.trilead.ssh2.crypto.cipher.CipherOutputStream;
import com.trilead.ssh2.crypto.cipher.NullCipher;
import com.trilead.ssh2.crypto.digest.MAC;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.Packets;
import com.trilead.ssh2.transport.ClientServerHello;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class TransportConnection {
    private static final Logger log = Logger.getLogger(TransportConnection.class);
    int send_seq_number = 0;
    int recv_seq_number = 0;
    CipherInputStream cis;
    CipherOutputStream cos;
    boolean useRandomPadding = false;
    MAC send_mac;
    byte[] send_mac_buffer;
    int send_padd_blocksize = 8;
    MAC recv_mac;
    byte[] recv_mac_buffer;
    byte[] recv_mac_buffer_cmp;
    int recv_padd_blocksize = 8;
    ICompressor recv_comp = null;
    ICompressor send_comp = null;
    boolean can_recv_compress = false;
    boolean can_send_compress = false;
    byte[] recv_comp_buffer;
    byte[] send_comp_buffer;
    final byte[] send_padding_buffer = new byte[256];
    final byte[] send_packet_header_buffer = new byte[5];
    final byte[] recv_padding_buffer = new byte[256];
    final byte[] recv_packet_header_buffer = new byte[5];
    ClientServerHello csh;
    final SecureRandom rnd;

    public TransportConnection(InputStream is, OutputStream os, SecureRandom rnd) {
        this.cis = new CipherInputStream(new NullCipher(), is);
        this.cos = new CipherOutputStream(new NullCipher(), os);
        this.rnd = rnd;
    }

    public void changeRecvCipher(BlockCipher bc, MAC mac) {
        this.cis.changeCipher(bc);
        this.recv_mac = mac;
        this.recv_mac_buffer = mac != null ? new byte[mac.size()] : null;
        this.recv_mac_buffer_cmp = mac != null ? new byte[mac.size()] : null;
        this.recv_padd_blocksize = bc.getBlockSize();
        if (this.recv_padd_blocksize < 8) {
            this.recv_padd_blocksize = 8;
        }
    }

    public void changeSendCipher(BlockCipher bc, MAC mac) {
        if (!(bc instanceof NullCipher)) {
            this.useRandomPadding = true;
        }
        this.cos.changeCipher(bc);
        this.send_mac = mac;
        this.send_mac_buffer = mac != null ? new byte[mac.size()] : null;
        this.send_padd_blocksize = bc.getBlockSize();
        if (this.send_padd_blocksize < 8) {
            this.send_padd_blocksize = 8;
        }
    }

    public void changeRecvCompression(ICompressor comp) {
        this.recv_comp = comp;
        if (comp != null) {
            this.recv_comp_buffer = new byte[comp.getBufferSize()];
            this.can_recv_compress |= this.recv_comp.canCompressPreauth();
        }
    }

    public void changeSendCompression(ICompressor comp) {
        this.send_comp = comp;
        if (comp != null) {
            this.send_comp_buffer = new byte[comp.getBufferSize()];
            this.can_send_compress |= this.send_comp.canCompressPreauth();
        }
    }

    public void sendMessage(byte[] message) throws IOException {
        this.sendMessage(message, 0, message.length, 0);
    }

    public void sendMessage(byte[] message, int off, int len) throws IOException {
        this.sendMessage(message, off, len, 0);
    }

    public int getPacketOverheadEstimate() {
        return 9 + (this.send_padd_blocksize - 1) + this.send_mac_buffer.length;
    }

    public void sendMessage(byte[] message, int off, int len, int padd) throws IOException {
        int i;
        boolean encryptThenMac;
        int encryptedPacketLength;
        int slack;
        if (padd < 4) {
            padd = 4;
        } else if (padd > 64) {
            padd = 64;
        }
        if (this.send_comp != null && this.can_send_compress) {
            if (this.send_comp_buffer.length < message.length + 1024) {
                this.send_comp_buffer = new byte[message.length + 1024];
            }
            len = this.send_comp.compress(message, off, len, this.send_comp_buffer);
            message = this.send_comp_buffer;
        }
        if ((slack = (encryptedPacketLength = ((encryptThenMac = this.send_mac != null && this.send_mac.isEncryptThenMac()) ? 1 : 5) + len + padd) % this.send_padd_blocksize) != 0) {
            encryptedPacketLength += this.send_padd_blocksize - slack;
        }
        if (encryptedPacketLength < 16) {
            encryptedPacketLength = 16;
        }
        int padd_len = encryptedPacketLength - ((encryptThenMac ? 1 : 5) + len);
        if (this.useRandomPadding) {
            for (i = 0; i < padd_len; i += 4) {
                int r = this.rnd.nextInt();
                this.send_padding_buffer[i] = (byte)r;
                this.send_padding_buffer[i + 1] = (byte)(r >> 8);
                this.send_padding_buffer[i + 2] = (byte)(r >> 16);
                this.send_padding_buffer[i + 3] = (byte)(r >> 24);
            }
        } else {
            for (i = 0; i < padd_len; ++i) {
                this.send_padding_buffer[i] = 0;
            }
        }
        int payloadLength = encryptThenMac ? encryptedPacketLength : encryptedPacketLength - 4;
        this.send_packet_header_buffer[0] = (byte)(encryptedPacketLength >> 24);
        this.send_packet_header_buffer[1] = (byte)(payloadLength >> 16);
        this.send_packet_header_buffer[2] = (byte)(payloadLength >> 8);
        this.send_packet_header_buffer[3] = (byte)payloadLength;
        this.send_packet_header_buffer[4] = (byte)padd_len;
        if (this.send_mac != null && this.send_mac.isEncryptThenMac()) {
            this.cos.writePlain(this.send_packet_header_buffer, 0, 4);
            this.cos.startRecording();
            this.cos.write(this.send_packet_header_buffer, 4, 1);
        } else {
            this.cos.write(this.send_packet_header_buffer, 0, 5);
        }
        this.cos.write(message, off, len);
        this.cos.write(this.send_padding_buffer, 0, padd_len);
        if (this.send_mac != null) {
            this.send_mac.initMac(this.send_seq_number);
            if (this.send_mac.isEncryptThenMac()) {
                this.send_mac.update(this.send_packet_header_buffer, 0, 4);
                byte[] encryptedMessage = this.cos.getRecordedOutput();
                this.send_mac.update(encryptedMessage, 0, encryptedMessage.length);
            } else {
                this.send_mac.update(this.send_packet_header_buffer, 0, 5);
                this.send_mac.update(message, off, len);
                this.send_mac.update(this.send_padding_buffer, 0, padd_len);
            }
            this.send_mac.getMac(this.send_mac_buffer, 0);
            this.cos.writePlain(this.send_mac_buffer, 0, this.send_mac_buffer.length);
        }
        this.cos.flush();
        if (log.isEnabled()) {
            log.log(90, "Sent " + Packets.getMessageName(message[off] & 0xFF) + " " + len + " bytes payload");
        }
        ++this.send_seq_number;
    }

    public int receiveMessage(byte[] buffer, int off, int len) throws IOException {
        int packetLength;
        if (this.recv_mac != null && this.recv_mac.isEncryptThenMac()) {
            this.cis.readPlain(this.recv_packet_header_buffer, 0, 4);
            packetLength = TransportConnection.getPacketLength(this.recv_packet_header_buffer, true);
            this.recv_mac.initMac(this.recv_seq_number);
            this.recv_mac.update(this.recv_packet_header_buffer, 0, 4);
            this.cis.peekPlain(buffer, off, packetLength + this.recv_mac_buffer.length);
            System.arraycopy(buffer, off + packetLength, this.recv_mac_buffer, 0, this.recv_mac_buffer.length);
            this.recv_mac.update(buffer, off, packetLength);
            this.recv_mac.getMac(this.recv_mac_buffer_cmp, 0);
            TransportConnection.checkMacMatches(this.recv_mac_buffer, this.recv_mac_buffer_cmp);
            this.cis.read(this.recv_packet_header_buffer, 4, 1);
        } else {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
            packetLength = TransportConnection.getPacketLength(this.recv_packet_header_buffer, false);
        }
        int paddingLength = this.recv_packet_header_buffer[4] & 0xFF;
        int payloadLength = TransportConnection.calculatePayloadLength(len, packetLength, paddingLength);
        this.cis.read(buffer, off, payloadLength);
        this.cis.read(this.recv_padding_buffer, 0, paddingLength);
        if (this.recv_mac != null) {
            this.cis.readPlain(this.recv_mac_buffer, 0, this.recv_mac_buffer.length);
            if (!this.recv_mac.isEncryptThenMac()) {
                this.recv_mac.initMac(this.recv_seq_number);
                this.recv_mac.update(this.recv_packet_header_buffer, 0, 5);
                this.recv_mac.update(buffer, off, payloadLength);
                this.recv_mac.update(this.recv_padding_buffer, 0, paddingLength);
                this.recv_mac.getMac(this.recv_mac_buffer_cmp, 0);
                TransportConnection.checkMacMatches(this.recv_mac_buffer, this.recv_mac_buffer_cmp);
            }
        }
        ++this.recv_seq_number;
        if (log.isEnabled()) {
            log.log(90, "Received " + Packets.getMessageName(buffer[off] & 0xFF) + " " + payloadLength + " bytes payload");
        }
        if (this.recv_comp != null && this.can_recv_compress) {
            int[] uncomp_len = new int[]{payloadLength};
            if ((buffer = this.recv_comp.uncompress(buffer, off, uncomp_len)) == null) {
                throw new IOException("Error while inflating remote data");
            }
            return uncomp_len[0];
        }
        return payloadLength;
    }

    private static int calculatePayloadLength(int bufferLength, int packetLength, int paddingLength) throws IOException {
        int payloadLength = packetLength - paddingLength - 1;
        if (payloadLength < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + paddingLength + ")");
        }
        if (payloadLength >= bufferLength) {
            throw new IOException("Receive buffer too small (" + bufferLength + ", need " + payloadLength + ")");
        }
        return payloadLength;
    }

    private static void checkMacMatches(byte[] buf1, byte[] buf2) throws IOException {
        int difference = 0;
        for (int i = 0; i < buf1.length; ++i) {
            difference |= buf1[i] ^ buf2[i];
        }
        if (difference != 0) {
            throw new IOException("Remote sent corrupt MAC.");
        }
    }

    private static int getPacketLength(byte[] packetHeader, boolean isEtm) throws IOException {
        int packetLength = (packetHeader[0] & 0xFF) << 24 | (packetHeader[1] & 0xFF) << 16 | (packetHeader[2] & 0xFF) << 8 | packetHeader[3] & 0xFF;
        if (packetLength > 35000 || packetLength < (isEtm ? 8 : 12)) {
            throw new IOException("Illegal packet size! (" + packetLength + ")");
        }
        return packetLength;
    }

    public void startCompression() {
        this.can_recv_compress = true;
        this.can_send_compress = true;
    }
}

