/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.writetolog;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLog;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLogData;
import org.w3c.dom.Node;

@Transform(id="WriteToLog", image="writetolog.svg", name="i18n::WriteToLog.Name", description="i18n::WriteToLog.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::WriteToLogMeta.keyword"}, documentationUrl="/pipeline/transforms/writetolog.html")
public class WriteToLogMeta
extends BaseTransformMeta<WriteToLog, WriteToLogData> {
    private static final Class<?> PKG = WriteToLogMeta.class;
    private String[] fieldName;
    public static String[] logLevelCodes = new String[]{"log_level_nothing", "log_level_error", "log_level_minimal", "log_level_basic", "log_level_detailed", "log_level_debug", "log_level_rowlevel"};
    private boolean displayHeader;
    private boolean limitRows;
    private int limitRowsNumber;
    private String logmessage;
    private String loglevel;

    public int getLogLevel() {
        return Arrays.asList(logLevelCodes).indexOf(this.loglevel);
    }

    public void setLogLevel(int i) {
        this.loglevel = logLevelCodes[i];
    }

    public LogLevel getLogLevelByDesc() {
        if (this.loglevel == null) {
            return LogLevel.BASIC;
        }
        LogLevel retval = this.loglevel.equals(logLevelCodes[0]) ? LogLevel.NOTHING : (this.loglevel.equals(logLevelCodes[1]) ? LogLevel.ERROR : (this.loglevel.equals(logLevelCodes[2]) ? LogLevel.MINIMAL : (this.loglevel.equals(logLevelCodes[3]) ? LogLevel.BASIC : (this.loglevel.equals(logLevelCodes[4]) ? LogLevel.DETAILED : (this.loglevel.equals(logLevelCodes[5]) ? LogLevel.DEBUG : LogLevel.ROWLEVEL)))));
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        WriteToLogMeta retval = (WriteToLogMeta)((Object)super.clone());
        int nrFields = this.fieldName.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrFields);
        return retval;
    }

    public void allocate(int nrFields) {
        this.fieldName = new String[nrFields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isDisplayHeader() {
        return this.displayHeader;
    }

    public void setDisplayHeader(boolean displayheader) {
        this.displayHeader = displayheader;
    }

    public boolean isLimitRows() {
        return this.limitRows;
    }

    public void setLimitRows(boolean limitRows) {
        this.limitRows = limitRows;
    }

    public int getLimitRowsNumber() {
        return this.limitRowsNumber;
    }

    public void setLimitRowsNumber(int limitRowsNumber) {
        this.limitRowsNumber = limitRowsNumber;
    }

    public String getLogMessage() {
        if (this.logmessage == null) {
            this.logmessage = "";
        }
        return this.logmessage;
    }

    public void setLogMessage(String s) {
        this.logmessage = s;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.loglevel = XmlHandler.getTagValue((Node)transformNode, (String)"loglevel");
            this.displayHeader = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"displayHeader"));
            this.limitRows = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"limitRows"));
            String limitRowsNumberString = XmlHandler.getTagValue((Node)transformNode, (String)"limitRowsNumber");
            this.limitRowsNumber = Const.toInt((String)limitRowsNumberString, (int)5);
            this.logmessage = XmlHandler.getTagValue((Node)transformNode, (String)"logmessage");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("      " + XmlHandler.addTagValue((String)"loglevel", (String)this.loglevel));
        retval.append("      " + XmlHandler.addTagValue((String)"displayHeader", (boolean)this.displayHeader));
        retval.append("      " + XmlHandler.addTagValue((String)"limitRows", (boolean)this.limitRows));
        retval.append("      " + XmlHandler.addTagValue((String)"limitRowsNumber", (int)this.limitRowsNumber));
        retval.append("      " + XmlHandler.addTagValue((String)"logmessage", (String)this.logmessage));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void setDefault() {
        this.loglevel = logLevelCodes[3];
        this.displayHeader = true;
        this.logmessage = "";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.fieldName[i] = "field" + i;
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.fieldName[i] + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

