/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetQueueAttributesRequestMarshaller
implements Marshaller<Request<SetQueueAttributesRequest>, SetQueueAttributesRequest> {
    public Request<SetQueueAttributesRequest> marshall(SetQueueAttributesRequest setQueueAttributesRequest) {
        if (setQueueAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setQueueAttributesRequest, "AmazonSQS");
        request.addParameter("Action", "SetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (setQueueAttributesRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)setQueueAttributesRequest.getQueueUrl()));
        }
        Map<String, String> attributes = setQueueAttributesRequest.getAttributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry != null && entry.getKey() != null) {
                request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry != null && entry.getValue() != null) {
                request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

