/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.metainput;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.metainput.MetadataInputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MetadataInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = MetadataInputMeta.class;
    private Text wTransformName;
    private Text wProvider;
    private Text wTypeKey;
    private Text wTypeName;
    private Text wTypeDescription;
    private Text wTypeClass;
    private Text wName;
    private Text wJson;
    private TableView wTypeFilters;
    private final MetadataInputMeta input;

    public MetadataInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (MetadataInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MetadataInput.Transform.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        MetadataInputDialog metadataInputDialog = this;
        int margin = metadataInputDialog.props.getMargin();
        boolean isReceivingInput = this.pipelineMeta.findPreviousTransforms(this.transformMeta).size() > 0;
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlProvider = new Label((Composite)this.shell, 131072);
        wlProvider.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.ProviderField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProvider);
        FormData fdlProvider = new FormData();
        fdlProvider.left = new FormAttachment(0, 0);
        fdlProvider.right = new FormAttachment(middle, -margin);
        fdlProvider.top = new FormAttachment((Control)lastControl, margin);
        wlProvider.setLayoutData((Object)fdlProvider);
        this.wProvider = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wProvider);
        this.wProvider.addModifyListener(lsMod);
        FormData fdProvider = new FormData();
        fdProvider.left = new FormAttachment(middle, 0);
        fdProvider.top = new FormAttachment((Control)lastControl, margin);
        fdProvider.right = new FormAttachment(100, 0);
        this.wProvider.setLayoutData((Object)fdProvider);
        lastControl = this.wProvider;
        Label wlTypeKey = new Label((Composite)this.shell, 131072);
        wlTypeKey.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.TypeKeyField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypeKey);
        FormData fdlTypeKey = new FormData();
        fdlTypeKey.left = new FormAttachment(0, 0);
        fdlTypeKey.right = new FormAttachment(middle, -margin);
        fdlTypeKey.top = new FormAttachment((Control)lastControl, margin);
        wlTypeKey.setLayoutData((Object)fdlTypeKey);
        this.wTypeKey = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTypeKey);
        this.wTypeKey.addModifyListener(lsMod);
        FormData fdTypeKey = new FormData();
        fdTypeKey.left = new FormAttachment(middle, 0);
        fdTypeKey.top = new FormAttachment((Control)lastControl, margin);
        fdTypeKey.right = new FormAttachment(100, 0);
        this.wTypeKey.setLayoutData((Object)fdTypeKey);
        lastControl = this.wTypeKey;
        Label wlTypeName = new Label((Composite)this.shell, 131072);
        wlTypeName.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.TypeNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypeName);
        FormData fdlTypeName = new FormData();
        fdlTypeName.left = new FormAttachment(0, 0);
        fdlTypeName.right = new FormAttachment(middle, -margin);
        fdlTypeName.top = new FormAttachment((Control)lastControl, margin);
        wlTypeName.setLayoutData((Object)fdlTypeName);
        this.wTypeName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTypeName);
        this.wTypeName.addModifyListener(lsMod);
        FormData fdTypeName = new FormData();
        fdTypeName.left = new FormAttachment(middle, 0);
        fdTypeName.top = new FormAttachment((Control)lastControl, margin);
        fdTypeName.right = new FormAttachment(100, 0);
        this.wTypeName.setLayoutData((Object)fdTypeName);
        lastControl = this.wTypeName;
        Label wlTypeDescription = new Label((Composite)this.shell, 131072);
        wlTypeDescription.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.TypeDescriptionField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypeDescription);
        FormData fdlTypeDescription = new FormData();
        fdlTypeDescription.left = new FormAttachment(0, 0);
        fdlTypeDescription.right = new FormAttachment(middle, -margin);
        fdlTypeDescription.top = new FormAttachment((Control)lastControl, margin);
        wlTypeDescription.setLayoutData((Object)fdlTypeDescription);
        this.wTypeDescription = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTypeDescription);
        this.wTypeDescription.addModifyListener(lsMod);
        FormData fdTypeDescription = new FormData();
        fdTypeDescription.left = new FormAttachment(middle, 0);
        fdTypeDescription.top = new FormAttachment((Control)lastControl, margin);
        fdTypeDescription.right = new FormAttachment(100, 0);
        this.wTypeDescription.setLayoutData((Object)fdTypeDescription);
        lastControl = this.wTypeDescription;
        Label wlTypeClass = new Label((Composite)this.shell, 131072);
        wlTypeClass.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.TypeClassField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypeClass);
        FormData fdlTypeClass = new FormData();
        fdlTypeClass.left = new FormAttachment(0, 0);
        fdlTypeClass.right = new FormAttachment(middle, -margin);
        fdlTypeClass.top = new FormAttachment((Control)lastControl, margin);
        wlTypeClass.setLayoutData((Object)fdlTypeClass);
        this.wTypeClass = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTypeClass);
        this.wTypeClass.addModifyListener(lsMod);
        FormData fdTypeClass = new FormData();
        fdTypeClass.left = new FormAttachment(middle, 0);
        fdTypeClass.top = new FormAttachment((Control)lastControl, margin);
        fdTypeClass.right = new FormAttachment(100, 0);
        this.wTypeClass.setLayoutData((Object)fdTypeClass);
        lastControl = this.wTypeClass;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.NameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment((Control)lastControl, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment((Control)lastControl, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        lastControl = this.wName;
        Label wlJson = new Label((Composite)this.shell, 131072);
        wlJson.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.JsonField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlJson);
        FormData fdlJson = new FormData();
        fdlJson.left = new FormAttachment(0, 0);
        fdlJson.right = new FormAttachment(middle, -margin);
        fdlJson.top = new FormAttachment((Control)lastControl, margin);
        wlJson.setLayoutData((Object)fdlJson);
        this.wJson = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wJson);
        this.wJson.addModifyListener(lsMod);
        FormData fdJson = new FormData();
        fdJson.left = new FormAttachment(middle, 0);
        fdJson.top = new FormAttachment((Control)lastControl, margin);
        fdJson.right = new FormAttachment(100, 0);
        this.wJson.setLayoutData((Object)fdJson);
        lastControl = this.wJson;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.setEnabled(!isReceivingInput);
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        Label wlTypeFilters = new Label((Composite)this.shell, 0);
        wlTypeFilters.setText(BaseMessages.getString(PKG, (String)"MetadataInputDialog.TypeFilters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypeFilters);
        FormData fdlTypeFilters = new FormData();
        fdlTypeFilters.left = new FormAttachment(0, 0);
        fdlTypeFilters.top = new FormAttachment((Control)lastControl, margin);
        wlTypeFilters.setLayoutData((Object)fdlTypeFilters);
        int fieldsRows = this.input.getTypeKeyFilters().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetadataInputDialog.KeyColumn.Column", (String[])new String[0]), 2, HopMetadataUtil.getHopMetadataKeys((IHopMetadataProvider)this.metadataProvider))};
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"MetadataInputDialog.KeyColumn.Tooltip", (String[])new String[0]));
        colinf[0].setUsingVariables(true);
        this.wTypeFilters = new TableView(this.variables, (Composite)this.shell, 67586, colinf, fieldsRows, lsMod, this.props);
        FormData fdTypeFilters = new FormData();
        fdTypeFilters.left = new FormAttachment(0, 0);
        fdTypeFilters.top = new FormAttachment((Control)wlTypeFilters, margin);
        fdTypeFilters.right = new FormAttachment(100, 0);
        fdTypeFilters.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTypeFilters.setLayoutData((Object)fdTypeFilters);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wProvider.setText(Const.NVL((String)this.input.getProviderFieldName(), (String)""));
        this.wTypeKey.setText(Const.NVL((String)this.input.getTypeKeyFieldName(), (String)""));
        this.wTypeName.setText(Const.NVL((String)this.input.getTypeNameFieldName(), (String)""));
        this.wTypeDescription.setText(Const.NVL((String)this.input.getTypeDescriptionFieldName(), (String)""));
        this.wTypeClass.setText(Const.NVL((String)this.input.getTypeClassFieldName(), (String)""));
        this.wName.setText(Const.NVL((String)this.input.getNameFieldName(), (String)""));
        this.wJson.setText(Const.NVL((String)this.input.getJsonFieldName(), (String)""));
        for (int i = 0; i < this.input.getTypeKeyFilters().size(); ++i) {
            TableItem item = this.wTypeFilters.table.getItem(i);
            int index = 1;
            item.setText(index++, Const.NVL((String)this.input.getTypeKeyFilters().get(i), (String)""));
        }
        this.wTypeFilters.setRowNums();
        this.wTypeFilters.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(MetadataInputMeta input) throws HopException {
        this.transformName = this.wTransformName.getText();
        input.setProviderFieldName(this.wProvider.getText());
        input.setTypeKeyFieldName(this.wTypeKey.getText());
        input.setTypeNameFieldName(this.wTypeName.getText());
        input.setTypeDescriptionFieldName(this.wTypeDescription.getText());
        input.setTypeClassFieldName(this.wTypeClass.getText());
        input.setNameFieldName(this.wName.getText());
        input.setJsonFieldName(this.wJson.getText());
        input.getTypeKeyFilters().clear();
        for (TableItem item : this.wTypeFilters.getNonEmptyItems()) {
            int index = 1;
            input.getTypeKeyFilters().add(item.getText(index));
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, "Error", "Error saving transform information", (Exception)((Object)e));
        }
        this.dispose();
    }

    private void preview() {
        try {
            MetadataInputMeta oneMeta = new MetadataInputMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{1000});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetadataInputDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataInputDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

