/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.msgboxinfo;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.GuiFactory;
import org.apache.hop.core.gui.IThreadDialogs;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.w3c.dom.Node;

@Action(id="MSGBOX_INFO", name="i18n::ActionMsgBoxInfo.Name", description="i18n::ActionMsgBoxInfo.Description", image="MsgBoxInfo.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionMsgBoxInfo.keyword"}, documentationUrl="/workflow/actions/msgboxinfo.html")
public class ActionMsgBoxInfo
extends ActionBase
implements Cloneable,
IAction {
    private String bodymessage = null;
    private String titremessage = null;

    public ActionMsgBoxInfo(String n, String scr) {
        super(n, "");
    }

    public ActionMsgBoxInfo() {
        this("", "");
    }

    public Object clone() {
        ActionMsgBoxInfo je = (ActionMsgBoxInfo)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(50);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"bodymessage", (String)this.bodymessage));
        retval.append("      ").append(XmlHandler.addTagValue((String)"titremessage", (String)this.titremessage));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.bodymessage = XmlHandler.getTagValue((Node)entrynode, (String)"bodymessage");
            this.titremessage = XmlHandler.getTagValue((Node)entrynode, (String)"titremessage");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load action of type 'Msgbox Info' from XML node", (Throwable)e);
        }
    }

    public boolean evaluate(Result result) {
        try {
            boolean response = true;
            IThreadDialogs dialogs = GuiFactory.getThreadDialogs();
            if (dialogs != null) {
                response = dialogs.threadMessageBox(this.getRealBodyMessage() + Const.CR, this.getRealTitleMessage(), true, 3);
            }
            return response;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError("Couldn't display message box: " + e.toString());
            return false;
        }
    }

    public Result execute(Result prevResult, int nr) {
        prevResult.setResult(this.evaluate(prevResult));
        return prevResult;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getRealTitleMessage() {
        return this.resolve(this.getTitleMessage());
    }

    public String getRealBodyMessage() {
        return this.resolve(this.getBodyMessage());
    }

    public String getTitleMessage() {
        if (this.titremessage == null) {
            this.titremessage = "";
        }
        return this.titremessage;
    }

    public String getBodyMessage() {
        if (this.bodymessage == null) {
            this.bodymessage = "";
        }
        return this.bodymessage;
    }

    public void setBodyMessage(String s) {
        this.bodymessage = s;
    }

    public void setTitleMessage(String s) {
        this.titremessage = s;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.addOkRemark((ICheckResultSource)this, (String)"bodyMessage", remarks);
        ActionValidatorUtils.addOkRemark((ICheckResultSource)this, (String)"titleMessage", remarks);
    }
}

