/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class WindowProperty {
    private String name;
    private boolean maximized;
    private int x;
    private int y;
    private int width;
    private int height;

    public WindowProperty() {
        this.name = null;
        this.maximized = false;
        this.x = -1;
        this.y = -1;
        this.width = -1;
        this.height = -1;
    }

    public WindowProperty(String name, boolean maximized, int x, int y, int width, int height) {
        this.name = name;
        this.maximized = maximized;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public WindowProperty(Shell shell) {
        this.name = shell.getText();
        this.maximized = shell.getMaximized();
        Rectangle rectangle = shell.getBounds();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public WindowProperty(String windowName, Map<String, Object> stateProperties) {
        this.name = windowName;
        this.setStateProperties(stateProperties);
    }

    public void setShell(Shell shell) {
        this.setShell(shell, false);
    }

    public void setShell(Shell shell, boolean onlyPosition) {
        this.setShell(shell, onlyPosition, -1, -1);
    }

    public void setShell(Shell shell, int minWidth, int minHeight) {
        this.setShell(shell, false, minWidth, minHeight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowProperty that = (WindowProperty)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean hasSize() {
        return this.width > 0 && this.height > 0;
    }

    public boolean hasPosition() {
        return this.x > 0 && this.y > 0;
    }

    public Map<String, Object> getStateProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("max", this.maximized);
        map.put("x", this.x);
        map.put("y", this.y);
        map.put("width", this.width);
        map.put("height", this.height);
        return map;
    }

    public void setStateProperties(Map<String, Object> map) {
        Boolean bMaximized = (Boolean)map.get("max");
        this.maximized = bMaximized == null ? false : bMaximized;
        Integer iX = (Integer)map.get("x");
        this.x = iX == null ? -1 : iX;
        Integer iY = (Integer)map.get("y");
        this.y = iY == null ? -1 : iY;
        Integer iWidth = (Integer)map.get("width");
        this.width = iWidth == null ? -1 : iWidth;
        Integer iHeight = (Integer)map.get("height");
        this.height = iHeight == null ? -1 : iHeight;
    }

    public void setShell(Shell shell, boolean onlyPosition, int minWidth, int minHeight) {
        shell.setMaximized(this.maximized);
        shell.setBounds(new Rectangle(this.x, this.y, this.width, this.height));
        if (minWidth > 0 || minHeight > 0) {
            Rectangle bounds = shell.getBounds();
            if (bounds.width < minWidth) {
                bounds.width = minWidth;
            }
            if (bounds.height < minHeight) {
                bounds.height = minHeight;
            }
            shell.setSize(bounds.width, bounds.height);
        }
        Point computedSize = shell.computeSize(-1, -1);
        Rectangle shellSize = shell.getBounds();
        if (shellSize.width < computedSize.x) {
            shellSize.width = computedSize.x;
        }
        if (shellSize.height < computedSize.y) {
            shellSize.height = computedSize.y;
        }
        shell.setBounds(shellSize);
        Rectangle entireClientArea = shell.getDisplay().getClientArea();
        Rectangle resizedRect = new Rectangle(shellSize.x, shellSize.y, shellSize.width, shellSize.height);
        this.constrainRectangleToContainer(resizedRect, entireClientArea);
        if (!resizedRect.equals((Object)shellSize) || this.isClippedByUnalignedMonitors(resizedRect, shell.getDisplay())) {
            Monitor monitor = shell.getDisplay().getPrimaryMonitor();
            if (shell.getParent() != null) {
                monitor = shell.getParent().getMonitor();
            }
            Rectangle monitorClientArea = monitor.getClientArea();
            this.constrainRectangleToContainer(resizedRect, monitorClientArea);
            resizedRect.x = monitorClientArea.x + (monitorClientArea.width - resizedRect.width) / 2;
            resizedRect.y = monitorClientArea.y + (monitorClientArea.height - resizedRect.height) / 2;
            shell.setBounds(resizedRect);
        }
    }

    private void constrainRectangleToContainer(Rectangle child, Rectangle container) {
        Point originalSize = new Point(child.width, child.height);
        Point containerSize = new Point(container.width, container.height);
        Point oversize = new Point(originalSize.x - containerSize.x, originalSize.y - containerSize.y);
        if (oversize.x > 0) {
            child.width = originalSize.x - oversize.x;
        }
        if (oversize.y > 0) {
            child.height = originalSize.y - oversize.y;
        }
        if (child.x < container.x || child.y < container.y || child.x + child.width > container.x + container.width || child.y + child.height > container.y + container.height) {
            child.x = (container.width - child.width) / 2;
            child.y = (container.height - child.height) / 2;
        }
    }

    private boolean isClippedByUnalignedMonitors(Rectangle constrainee, Display display) {
        boolean isClipped;
        Monitor[] monitors = display.getMonitors();
        if (monitors.length > 0) {
            isClipped = true;
            for (Monitor monitor : monitors) {
                if (!monitor.getClientArea().contains(constrainee.x + 10, constrainee.y + 10)) continue;
                isClipped = false;
                break;
            }
        } else {
            isClipped = false;
        }
        return isClipped;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

