/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class HopDescribedVariablesDialog
extends Dialog {
    private static final Class<?> PKG = HopDescribedVariablesDialog.class;
    private TableView wFields;
    private Shell shell;
    private final PropsUi props;
    private String message;
    private List<DescribedVariable> describedVariables;
    private String selectedVariable;

    public HopDescribedVariablesDialog(Shell parent, String message, List<DescribedVariable> describedVariables, String selectedVariable) {
        super(parent, 0);
        this.message = message;
        this.describedVariables = describedVariables;
        this.selectedVariable = selectedVariable;
        this.props = PropsUi.getInstance();
    }

    public List<DescribedVariable> open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3184);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HopDescribedVariablesDialog.Title", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImage("ui/images/variable.svg", 16, 16));
        PropsUi.setLook((Widget)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        HopDescribedVariablesDialog hopDescribedVariablesDialog = this;
        int margin = hopDescribedVariablesDialog.props.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, margin, (Control)this.wFields);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(Const.NVL((String)this.message, (String)""));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsRows = 0;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Name.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Value.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Description.Label", (String[])new String[0]), 1, false, false)};
        columns[2].setDisabledListener(rowNr -> false);
        this.wFields = new TableView(Variables.getADefaultVariableSpace(), (Composite)this.shell, 67586, columns, fieldsRows, null, this.props);
        this.wFields.setReadonly(false);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, 2 * margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.describedVariables;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        try {
            for (DescribedVariable describedVariable : this.describedVariables) {
                TableItem item = new TableItem(this.wFields.table, 0);
                int col = 1;
                item.setText(col++, Const.NVL((String)describedVariable.getName(), (String)""));
                item.setText(col++, Const.NVL((String)describedVariable.getValue(), (String)""));
                item.setText(col++, Const.NVL((String)describedVariable.getDescription(), (String)""));
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
            if (this.selectedVariable != null) {
                for (TableItem item : this.wFields.table.getItems()) {
                    if (!item.getText(1).equals(this.selectedVariable)) continue;
                    this.wFields.table.setSelection(item);
                }
                this.wFields.table.showSelection();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Exception.ErrorLoadingData.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Exception.ErrorLoadingData.Message", (String[])new String[0]), e);
        }
    }

    private void cancel() {
        this.describedVariables = null;
        this.dispose();
    }

    private void ok() {
        this.describedVariables.clear();
        for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String name = item.getText(1);
            String value = item.getText(2);
            String description = item.getText(3);
            this.describedVariables.add(new DescribedVariable(name, value, description));
        }
        this.dispose();
    }
}

