/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public final class OutputReference
extends GenericJson {
    @Key(value="@type")
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"})
    public final @UnknownKeyFor @NonNull @Initialized String type = "OutputReference";
    @Key(value="step_name")
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    @Key(value="output_name")
    private final @UnknownKeyFor @NonNull @Initialized String outputName;

    public OutputReference(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized String outputName) {
        this.stepName = (String)Preconditions.checkNotNull((Object)stepName);
        this.outputName = (String)Preconditions.checkNotNull((Object)outputName);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object otherObject) {
        if (!(otherObject instanceof OutputReference)) {
            return false;
        }
        OutputReference other = (OutputReference)((Object)otherObject);
        return Objects.equals("OutputReference", other.type) && Objects.equals(this.stepName, other.stepName) && Objects.equals(this.outputName, other.outputName) && super.equals((Object)other);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash("OutputReference", this.stepName, this.outputName, super.hashCode());
    }
}

