/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.internal;

import com.google.api.client.util.Base64;
import com.google.api.services.dataflow.model.Source;
import com.google.api.services.dataflow.model.SourceMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSources {
    private static final @UnknownKeyFor @NonNull @Initialized String SERIALIZED_SOURCE = "serialized_source";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String SERIALIZED_SOURCE_SPLITS = "serialized_source_splits";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CustomSources.class);

    private static @UnknownKeyFor @NonNull @Initialized int getDesiredNumUnboundedSourceSplits(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        int cores = 4;
        if (options.getMaxNumWorkers() > 0) {
            return options.getMaxNumWorkers() * cores;
        }
        if (options.getNumWorkers() > 0) {
            return options.getNumWorkers() * cores;
        }
        return 5 * cores;
    }

    public static @UnknownKeyFor @NonNull @Initialized Source serializeToCloudSource(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.io.Source<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> source, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Source cloudSource = new Source();
        cloudSource.setSpec((Map)((Object)CloudObject.forClass(CustomSources.class)));
        Structs.addString(cloudSource.getSpec(), SERIALIZED_SOURCE, Base64.encodeBase64String((byte[])SerializableUtils.serializeToByteArray(source)));
        SourceMetadata metadata = new SourceMetadata();
        if (source instanceof BoundedSource) {
            BoundedSource boundedSource = (BoundedSource)source;
            try {
                metadata.setEstimatedSizeBytes(Long.valueOf(boundedSource.getEstimatedSizeBytes(options)));
            }
            catch (Exception e) {
                LOG.warn("Size estimation of the source failed: " + source, (Throwable)e);
            }
        } else if (source instanceof UnboundedSource) {
            UnboundedSource unboundedSource = (UnboundedSource)source;
            metadata.setInfinite(Boolean.valueOf(true));
            ArrayList<String> encodedSplits = new ArrayList<String>();
            int desiredNumSplits = CustomSources.getDesiredNumUnboundedSourceSplits((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class));
            for (UnboundedSource split : unboundedSource.split(desiredNumSplits, options)) {
                encodedSplits.add(Base64.encodeBase64String((byte[])SerializableUtils.serializeToByteArray((Serializable)split)));
            }
            Preconditions.checkArgument((!encodedSplits.isEmpty() ? 1 : 0) != 0, (Object)"UnboundedSources must have at least one split");
            Structs.addStringList(cloudSource.getSpec(), SERIALIZED_SOURCE_SPLITS, encodedSplits);
        } else {
            throw new IllegalArgumentException("Unexpected source kind: " + source.getClass());
        }
        cloudSource.setMetadata(metadata);
        return cloudSource;
    }
}

