/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class EnumValidator
implements ConfigDef.Validator {
    private final Set<String> validValues;

    public EnumValidator(Set<String> validValues) {
        this.validValues = validValues;
    }

    public static <T> EnumValidator in(T[] enumerators) {
        HashSet<String> validValues = new HashSet<String>(enumerators.length);
        for (T e : enumerators) {
            validValues.add(e.toString().toLowerCase());
        }
        return new EnumValidator(validValues);
    }

    public void ensureValid(String key, Object value) {
        if (!this.validValues.contains(value.toString().toLowerCase())) {
            throw new ConfigException(key, value, "Invalid enumeration value");
        }
    }
}

