/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.management.internal.ManagementResourceRepo;

public abstract class Manager {
    protected final InternalCacheForClientAccess cache;
    protected volatile boolean running;
    protected volatile boolean stopCacheOps;
    protected final ManagementResourceRepo repo;
    protected final InternalDistributedSystem system;
    protected final StatisticsFactory statisticsFactory;
    protected final StatisticsClock statisticsClock;

    public Manager(ManagementResourceRepo repo, InternalDistributedSystem system, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock) {
        this.repo = repo;
        this.cache = cache.getCacheForProcessingClientRequests();
        this.system = system;
        this.statisticsFactory = statisticsFactory;
        this.statisticsClock = statisticsClock;
    }

    public abstract boolean isRunning();

    public abstract void startManager();

    public abstract void stopManager();

    @VisibleForTesting
    public ManagementResourceRepo getManagementResourceRepo() {
        return this.repo;
    }
}

