/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;

public class StoppableNonReentrantLock
extends StoppableReentrantLock {
    public StoppableNonReentrantLock(CancelCriterion stopper) {
        super(stopper);
    }

    public StoppableNonReentrantLock(boolean fair, CancelCriterion stopper) {
        super(fair, stopper);
    }

    private void checkForRentry() {
        if (this.isHeldByCurrentThread()) {
            throw new IllegalStateException("Lock reentry is not allowed");
        }
    }

    @Override
    public void lock() {
        this.checkForRentry();
        super.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.checkForRentry();
        super.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        this.checkForRentry();
        return super.tryLock();
    }

    @Override
    public boolean tryLock(long timeoutMs) throws InterruptedException {
        this.checkForRentry();
        return super.tryLock(timeoutMs);
    }
}

