/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class SemaphoreReadWriteLock
implements ReadWriteLock {
    private SemaphoreReadLock readLock;
    private SemaphoreWriteLock writeLock;

    public SemaphoreReadWriteLock() {
        Semaphore writerSemaphore = new Semaphore(1);
        Semaphore readerSemaphore = new Semaphore(1);
        this.readLock = new SemaphoreReadLock(readerSemaphore, writerSemaphore);
        this.writeLock = new SemaphoreWriteLock(writerSemaphore);
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    public static class SemaphoreWriteLock
    implements Lock {
        private final Semaphore writerSemaphore;

        public SemaphoreWriteLock(Semaphore writerSemaphore) {
            this.writerSemaphore = writerSemaphore;
        }

        @Override
        public void lock() {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        this.lockInterruptibly();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.writerSemaphore.acquire();
        }

        @Override
        public boolean tryLock() {
            return this.writerSemaphore.tryAcquire();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.writerSemaphore.tryAcquire(time, unit);
        }

        @Override
        public void unlock() {
            this.writerSemaphore.release();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SemaphoreReadLock
    implements Lock {
        private int numReaders = 0;
        private final Semaphore readerSemaphore;
        private final Semaphore writerSemaphore;

        public SemaphoreReadLock(Semaphore readerSemaphore, Semaphore writerSemaphore) {
            this.readerSemaphore = readerSemaphore;
            this.writerSemaphore = writerSemaphore;
        }

        @Override
        public void lock() {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        this.lockInterruptibly();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.readerSemaphore.acquire();
            try {
                ++this.numReaders;
                if (this.numReaders == 1) {
                    this.writerSemaphore.acquire();
                }
            }
            finally {
                this.readerSemaphore.release();
            }
        }

        @Override
        public boolean tryLock() {
            boolean interrupted = false;
            while (true) {
                try {
                    boolean bl = this.tryLock(0L, TimeUnit.MILLISECONDS);
                    return bl;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            if (this.readerSemaphore.tryAcquire(time, unit)) {
                int oldNumReaders = this.numReaders++;
                if (this.numReaders == 1) {
                    if (this.writerSemaphore.tryAcquire(time, unit)) {
                        this.readerSemaphore.release();
                        return true;
                    }
                    this.numReaders = oldNumReaders;
                    this.readerSemaphore.release();
                    return false;
                }
                this.readerSemaphore.release();
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            while (true) {
                boolean interrupted = false;
                try {
                    this.readerSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            --this.numReaders;
            if (this.numReaders <= 0) {
                this.numReaders = 0;
                if (this.writerSemaphore.availablePermits() == 0) {
                    this.writerSemaphore.release();
                }
            }
            this.readerSemaphore.release();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

